/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DropViewFinalStep;
import org.neo4j.jdbc.internal.shaded.jooq.Function3;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractDDLQuery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DDLStatementType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class DropViewImpl
extends AbstractDDLQuery
implements QOM.DropView,
DropViewFinalStep {
    final Table<?> view;
    final boolean materialized;
    final boolean ifExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropViewImpl(Configuration configuration, Table<?> view, boolean materialized, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.materialized = materialized;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP).sql(' ');
        if (this.materialized) {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(Keywords.K_MATERIALIZED).sql(' ').visit(Keywords.K_VIEW).sql(' ');
        } else {
            ctx.visit(Keywords.K_VIEW).sql(' ');
        }
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final boolean $materialized() {
        return this.materialized;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.DropView $view(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$materialized(), this.$ifExists());
    }

    @Override
    public final QOM.DropView $materialized(boolean newValue) {
        return this.$constructor().apply(this.$view(), newValue, this.$ifExists());
    }

    @Override
    public final QOM.DropView $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$materialized(), newValue);
    }

    public final Function3<? super Table<?>, ? super Boolean, ? super Boolean, ? extends QOM.DropView> $constructor() {
        return (a1, a2, a3) -> new DropViewImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (boolean)a3);
    }
}

