/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.SelectField;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableOptions;
import org.neo4j.jdbc.internal.shaded.jooq.exception.SQLDialectNotSupportedException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.FieldsImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RecordImplN;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableAlias;

final class FunctionTable<R extends Record>
extends AbstractTable<R>
implements QOM.UNotYetImplemented {
    private final Field<?> function;

    FunctionTable(Field<?> function) {
        super(TableOptions.function(), Names.N_FUNCTION);
        this.function = function;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(new SelectField[0]);
    }

    @Override
    public final Table<R> as(Name as) {
        return new TableAlias<R>(new FunctionTable<R>(this.function), as);
    }

    @Override
    public final Table<R> as(Name as, Name ... fieldAliases) {
        return new TableAlias<R>(new FunctionTable<R>(this.function), as, fieldAliases);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case HSQLDB: {
                ctx.visit(Keywords.K_TABLE).sql('(').visit(this.function).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(this.function);
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("FUNCTION TABLE is not supported for " + String.valueOf((Object)ctx.dialect()));
            }
        }
    }
}

