/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.jooq.Commit;
import org.neo4j.jdbc.internal.shaded.jooq.Commits;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.History;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.Version;
import org.neo4j.jdbc.internal.shaded.jooq.conf.InterpreterSearchSchema;
import org.neo4j.jdbc.internal.shaded.jooq.conf.MappedCatalog;
import org.neo4j.jdbc.internal.shaded.jooq.conf.MappedSchema;
import org.neo4j.jdbc.internal.shaded.jooq.conf.MigrationSchema;
import org.neo4j.jdbc.internal.shaded.jooq.conf.RenderMapping;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataAccessException;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataMigrationVerificationException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractScope;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryRecord;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryResolution;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryStatus;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

class HistoryImpl
extends AbstractScope
implements History {
    final DSLContext ctx;
    final DSLContext historyCtx;
    final Commits commits;
    final List<Version> versions;

    HistoryImpl(Configuration configuration) {
        super(configuration);
        this.ctx = configuration.dsl();
        this.historyCtx = HistoryImpl.initCtx(configuration, configuration.settings().getMigrationHistorySchema()).dsl();
        this.commits = configuration.commitProvider().provide();
        this.versions = this.initVersions();
    }

    @Override
    public final Iterator<Version> iterator() {
        return Collections.unmodifiableList(this.versions).iterator();
    }

    @Override
    public final Version root() {
        if (!Tools.isEmpty(this.versions)) {
            return this.versions.get(0);
        }
        throw new DataMigrationVerificationException("No versions are available");
    }

    @Override
    public final Version current() {
        if (!Tools.isEmpty(this.versions)) {
            return this.versions.get(this.versions.size() - 1);
        }
        throw new DataMigrationVerificationException("No versions are available");
    }

    final Set<Schema> schemas() {
        LinkedHashSet<Schema> set = new LinkedHashSet<Schema>();
        for (MigrationSchema schema : this.configuration.settings().getMigrationSchemata()) {
            this.addSchema(set, schema);
        }
        if (this.configuration.settings().getMigrationDefaultSchema() != null) {
            this.addSchema(set, this.configuration.settings().getMigrationDefaultSchema());
            set.add(DSL.schema(""));
        }
        return set;
    }

    private final void addSchema(Set<Schema> set, MigrationSchema schema) {
        if (schema != null) {
            set.addAll(this.lookup(Arrays.asList(DSL.schema(DSL.name(schema.getCatalog(), schema.getSchema())))));
        }
    }

    final Collection<Schema> lookup(List<Schema> schemas) {
        Collection<Schema> result = schemas;
        List<InterpreterSearchSchema> searchPath = this.configuration().settings().getInterpreterSearchPath();
        if (!searchPath.isEmpty()) {
            result = new HashSet();
            Schema defaultSchema = DSL.schema(DSL.name(searchPath.get(0).getCatalog(), searchPath.get(0).getSchema()));
            for (Schema schema : schemas) {
                if (schema.getQualifiedName().empty()) {
                    result.add(defaultSchema);
                    continue;
                }
                result.add(schema);
            }
        }
        return result;
    }

    static final Configuration initCtx(Configuration configuration, MigrationSchema defaultSchema) {
        if (defaultSchema != null) {
            Configuration result = configuration.derive();
            if (!StringUtils.isBlank(defaultSchema.getCatalog())) {
                result.settings().withRenderMapping(new RenderMapping().withCatalogs(new MappedCatalog().withInput("").withOutput(defaultSchema.getCatalog()).withSchemata(new MappedSchema().withInput("").withOutput(defaultSchema.getSchema()))));
            } else if (!StringUtils.isBlank(defaultSchema.getSchema())) {
                result.settings().withRenderMapping(new RenderMapping().withSchemata(new MappedSchema().withInput("").withOutput(defaultSchema.getSchema())));
            }
            return result;
        }
        return configuration;
    }

    @Nullable
    final HistoryRecord currentHistoryRecord(boolean successOnly) {
        return this.existsHistory() ? (HistoryRecord)this.historyCtx.selectFrom(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY).where(successOnly ? org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS)) : org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS)).or(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.RESOLUTION.eq(HistoryResolution.OPEN))).orderBy(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.MIGRATED_AT.desc(), org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.ID.desc()).limit(1).fetchOne() : null;
    }

    final boolean existsHistory() {
        try {
            Configuration c = this.historyCtx.configuration().derive();
            c.data("org.neo4j.jdbc.internal.shaded.jooq.tools.LoggerListener.exception.mute", true);
            c.dsl().fetchExists(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY);
            return true;
        }
        catch (DataAccessException dataAccessException) {
            return false;
        }
    }

    private final List<Version> initVersions() {
        ArrayList<Version> result = new ArrayList<Version>();
        if (this.existsHistory()) {
            result.add(this.commits.root().version());
            for (HistoryRecord r : this.historyCtx.selectFrom(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY).where(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.STATUS.eq(DSL.inline(HistoryStatus.SUCCESS))).orderBy(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY.ID.asc())) {
                Commit commit = this.commits.get(r.getMigratedTo());
                if (commit != null) {
                    result.add(commit.version());
                    continue;
                }
                throw new DataMigrationVerificationException("CommitProvider didn't provide version for ID: " + r.getMigratedTo());
            }
        }
        return result;
    }

    final void init() {
        if (!this.existsHistory()) {
            if (Boolean.TRUE.equals(this.historyCtx.settings().isMigrationHistorySchemaCreateSchemaIfNotExists()) && this.historyCtx.settings().getMigrationHistorySchema() != null || Boolean.TRUE.equals(this.historyCtx.settings().isMigrationSchemataCreateSchemaIfNotExists()) && this.historyCtx.settings().getMigrationDefaultSchema() != null) {
                this.historyCtx.createSchemaIfNotExists("").execute();
            }
            this.historyCtx.meta(org.neo4j.jdbc.internal.shaded.jooq.impl.History.HISTORY).ddl().executeBatch();
        }
    }

    @Override
    public final void resolve(String message) {
        HistoryRecord h = this.currentHistoryRecord(false);
        if (h == null) {
            throw new DataMigrationVerificationException("No current history record found to resolve");
        }
        h.setResolution(HistoryResolution.RESOLVED).setResolutionMessage(message).update();
    }

    public int hashCode() {
        return this.versions.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof HistoryImpl) {
            HistoryImpl h = (HistoryImpl)obj;
            return this.versions.equals(h.versions);
        }
        return false;
    }

    public String toString() {
        return "History [" + String.valueOf(this.current()) + "]";
    }
}

