/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class IsNotJson
extends AbstractCondition
implements QOM.IsNotJson {
    final Field<?> field;

    IsNotJson(Field<?> field) {
        this.field = Tools.nullSafeNotNull(field, SQLDataType.OTHER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.condition(DSL.function(Names.N_JSON_VALID, SQLDataType.BOOLEAN, this.field)).not());
                break;
            }
            default: {
                ctx.visit(this.field).sql(' ').visit(Keywords.K_IS_NOT_JSON);
            }
        }
    }

    @Override
    public final Field<?> $arg1() {
        return this.field;
    }

    @Override
    public final QOM.IsNotJson $arg1(Field<?> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Field<?>, ? extends QOM.IsNotJson> $constructor() {
        return a1 -> new IsNotJson((Field<?>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.IsNotJson) {
            QOM.IsNotJson o = (QOM.IsNotJson)that;
            return Objects.equals(this.$field(), o.$field());
        }
        return super.equals(that);
    }
}

