/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.Method;
import org.neo4j.jdbc.internal.shaded.jooq.ConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.exception.MappingException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractContextConverter;
import org.neo4j.jdbc.internal.shaded.jooq.tools.JooqLogger;
import org.neo4j.jdbc.internal.shaded.jooq.tools.reflect.Reflect;

public final class JPAConverter<T, U>
extends AbstractContextConverter<T, U> {
    private static final JooqLogger log = JooqLogger.getLogger(JPAConverter.class);
    private final AttributeConverter<U, T> delegate;

    public JPAConverter(Class<? extends AttributeConverter<U, T>> klass) {
        super(JPAConverter.fromType(klass), JPAConverter.toType(klass));
        try {
            this.delegate = (AttributeConverter)Reflect.on(klass).create().get();
        }
        catch (Exception e) {
            throw new MappingException("Cannot instanciate AttributeConverter", e);
        }
    }

    private static final <T> Class<T> fromType(Class<? extends AttributeConverter<?, T>> klass) {
        Method candidate = null;
        for (Method method : klass.getDeclaredMethods()) {
            if (!"convertToDatabaseColumn".equals(method.getName())) continue;
            if (method.getReturnType() == Object.class) {
                candidate = method;
                continue;
            }
            return method.getReturnType();
        }
        if (candidate != null) {
            log.warn("Couldn't find bridge method to detect generic type bound for " + klass.getName() + "::convertToDatabaseColumn");
            return candidate.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    private static final <U> Class<U> toType(Class<? extends AttributeConverter<U, ?>> klass) {
        Method candidate = null;
        for (Method method : klass.getDeclaredMethods()) {
            if (!"convertToEntityAttribute".equals(method.getName())) continue;
            if (method.getReturnType() == Object.class) {
                candidate = method;
                continue;
            }
            return method.getReturnType();
        }
        if (candidate != null) {
            log.warn("Couldn't find bridge method to detect generic type bound for " + klass.getName() + "::convertToEntityAttribute");
            return candidate.getReturnType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final U from(T t, ConverterContext scope) {
        return (U)this.delegate.convertToEntityAttribute(t);
    }

    @Override
    public final T to(U u, ConverterContext scope) {
        return (T)this.delegate.convertToDatabaseColumn(u);
    }
}

