/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.JSONExistsOnStep;
import org.neo4j.jdbc.internal.shaded.jooq.Keyword;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Cast;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class JSONExists
extends AbstractCondition
implements JSONExistsOnStep,
QOM.UNotYetImplemented {
    private final Field<?> json;
    private final Field<String> path;

    JSONExists(Field<?> json, Field<String> path) {
        this(json, path, null);
    }

    private JSONExists(Field<?> json, Field<String> path, Behaviour onError) {
        this.json = json;
        this.path = path;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(Names.N_JSON_CONTAINS_PATH).sql('(').visit(this.json).sql(", 'one', ").visit(this.path).sql(')');
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_TYPE, SQLDataType.JSON, this.json, this.path).isNotNull());
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_JSONB_PATH_EXISTS).sql('(').visit(Tools.castIfNeeded(this.json, SQLDataType.JSONB)).sql(", ");
                Cast.renderCast(ctx, c -> c.visit(this.path), c -> c.visit(Names.N_JSONPATH));
                ctx.sql(')');
                break;
            }
            default: {
                ctx.visit(Keywords.K_JSON_EXISTS).sql('(').visit(this.json).sql(", ");
                ctx.visit(this.path);
                ctx.sql(')');
            }
        }
    }

    static enum Behaviour {
        ERROR,
        TRUE,
        FALSE,
        UNKNOWN;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

