/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.NClob;
import java.sql.SQLException;
import org.neo4j.jdbc.internal.shaded.jooq.Binding;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetResultSetContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetSQLInputContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingRegisterContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSQLContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSetSQLOutputContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.Converter;
import org.neo4j.jdbc.internal.shaded.jooq.Converters;
import org.neo4j.jdbc.internal.shaded.jooq.ResourceManagingScope;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ClobBinding;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultBinding;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultExecuteContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.JDBCUtils;

public class NClobBinding
implements Binding<String, String> {
    final ClobBinding clobBinding = new ClobBinding();

    @Override
    public final Converter<String, String> converter() {
        return Converters.identity(String.class);
    }

    @Override
    public final void sql(BindingSQLContext<String> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline((Object)ctx.convert(this.converter()).value(), SQLDataType.NCLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public final void register(BindingRegisterContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.register(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.statement().registerOutParameter(ctx.index(), 2011);
        } else {
            ctx.statement().registerOutParameter(ctx.index(), -9);
        }
    }

    @Override
    public final void set(BindingSetStatementContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.set(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            NClob clob = NClobBinding.newNClob(ctx, ctx.value());
            if (clob == null && ClobBinding.NO_SUPPORT_NULL_LOBS.contains((Object)ctx.dialect())) {
                ctx.statement().setNull(ctx.index(), 2011);
            } else {
                ctx.statement().setNClob(ctx.index(), clob);
            }
        } else {
            ctx.statement().setNString(ctx.index(), ctx.value());
        }
    }

    @Override
    public final void set(BindingSetSQLOutputContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.set(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.output().writeNClob(NClobBinding.newNClob(ctx, ctx.value()));
        } else {
            ctx.output().writeNString(ctx.value());
        }
    }

    @Override
    public final void get(BindingGetResultSetContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.get(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            NClob clob = ctx.resultSet().getNClob(ctx.index());
            try {
                ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.resultSet().getNString(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetStatementContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.get(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            NClob clob = ctx.statement().getNClob(ctx.index());
            try {
                ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.statement().getNString(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<String> ctx) throws SQLException {
        if (DefaultBinding.InternalBinding.NO_SUPPORT_NVARCHAR.contains((Object)ctx.dialect())) {
            this.clobBinding.get(ctx);
        } else if (!ClobBinding.NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            NClob clob = ctx.input().readNClob();
            try {
                ctx.value(clob == null ? null : clob.getSubString(1L, Tools.asInt(clob.length())));
            }
            finally {
                JDBCUtils.safeFree(clob);
            }
        } else {
            ctx.value(ctx.input().readNString());
        }
    }

    static final NClob newNClob(ResourceManagingScope scope, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (scope.dialect()) {
            default: 
        }
        NClob clob = DefaultExecuteContext.localConnection().createNClob();
        scope.autoFree(clob);
        clob.setString(1L, string);
        return clob;
    }
}

