/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Nullif<T>
extends AbstractField<T>
implements QOM.Nullif<T> {
    final Field<T> value;
    final Field<T> other;

    Nullif(Field<T> value, Field<T> other) {
        super(Names.N_NULLIF, Tools.nullable(Tools.dataType(value), value, other));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.OTHER);
        this.other = Tools.nullSafeNotNull(other, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(DSL.function(Names.N_NULLIF, this.getDataType(), this.value, this.other));
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<T> $arg2() {
        return this.other;
    }

    @Override
    public final QOM.Nullif<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.Nullif<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.Nullif<T>> $constructor() {
        return (a1, a2) -> new Nullif(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Nullif) {
            QOM.Nullif o = (QOM.Nullif)that;
            return Objects.equals(this.$value(), o.$value()) && Objects.equals(this.$other(), o.$other());
        }
        return super.equals(that);
    }
}

