/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;

final class RegexpLike
extends AbstractCondition
implements QOM.RegexpLike {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Field<?> search;
    private final Field<String> pattern;

    RegexpLike(Field<?> search, Field<String> pattern) {
        this.search = search;
        this.pattern = pattern;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case H2: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ctx.visit(this.search).sql(' ').visit(Keywords.K_REGEXP).sql(' ').visit(this.pattern);
                break;
            }
            case HSQLDB: {
                ctx.visit(DSL.keyword("regexp_matches")).sql('(').visit(this.search).sql(", ").visit(this.pattern).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.sql('(').visit(this.search).sql(" ~ ").visit(this.pattern).sql(')');
                break;
            }
            default: {
                ctx.sql('(').visit(this.search).sql(' ').visit(Keywords.K_LIKE_REGEX).sql(' ').visit(this.pattern).sql(')');
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Field<?> $search() {
        return this.search;
    }

    @Override
    public final Field<String> $pattern() {
        return this.pattern;
    }
}

