/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.types.DayToSecond;

final class TimestampDiff<T>
extends AbstractField<DayToSecond>
implements QOM.TimestampDiff<T> {
    private final Field<T> timestamp1;
    private final Field<T> timestamp2;

    TimestampDiff(Field<T> timestamp1, Field<T> timestamp2) {
        super(Names.N_TIMESTAMPDIFF, SQLDataType.INTERVALDAYTOSECOND);
        this.timestamp1 = timestamp1;
        this.timestamp2 = timestamp2;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.sql('(').visit(this.timestamp1).sql(" - ").visit(this.timestamp2).sql(')');
                break;
            }
            case CUBRID: {
                ctx.visit(this.timestamp1.sub(this.timestamp2));
                break;
            }
            case DERBY: {
                ctx.sql("1000 * {fn ").visit(Names.N_TIMESTAMPDIFF).sql('(').visit(DSL.keyword("sql_tsi_second")).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(") }");
                break;
            }
            case FIREBIRD: {
                ctx.visit(Names.N_DATEDIFF).sql('(').visit(Keywords.K_MILLISECOND).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(')');
                break;
            }
            case H2: 
            case HSQLDB: {
                ctx.visit(Names.N_DATEDIFF).sql("('ms', ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(')');
                break;
            }
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_TIMESTAMPDIFF).sql('(').visit(DSL.keyword("microsecond")).sql(", ").visit(this.timestamp2).sql(", ").visit(this.timestamp1).sql(") / 1000");
                break;
            }
            case SQLITE: {
                ctx.sql('(').visit(Names.N_STRFTIME).sql("('%s', ").visit(this.timestamp1).sql(") - ").visit(Names.N_STRFTIME).sql("('%s', ").visit(this.timestamp2).sql(")) * 1000");
                break;
            }
            default: {
                ctx.visit(Tools.castIfNeeded(this.timestamp1.sub(this.timestamp2), DayToSecond.class));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.timestamp1;
    }

    @Override
    public final Field<T> $arg2() {
        return this.timestamp2;
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.TimestampDiff<T>> $constructor() {
        return (t1, t2) -> new TimestampDiff(t1, t2);
    }
}

