/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Transformation;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SelectQueryImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class Transformations {
    static final Set<SQLDialect> NO_SUPPORT_IN_LIMIT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    static final Set<SQLDialect> SUPPORT_MISSING_TABLE_REFERENCES = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> EMULATE_QUALIFY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_ROWNUM = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_GROUP_BY_COLUMN_INDEX = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE);
    static final Set<SQLDialect> NO_SUPPORT_CTE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY);

    Transformations() {
    }

    static final SelectQueryImpl<?> subqueryWithLimit(QueryPart source) {
        SelectQueryImpl s = Tools.selectQueryImpl(source);
        return s != null && s.getLimit().isApplicable() ? s : null;
    }

    static final boolean transformInConditionSubqueryWithLimitToDerivedTable(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformInConditionSubqueryWithLimitToDerivedTable", configuration.settings().getTransformInConditionSubqueryWithLimitToDerivedTable(), c -> NO_SUPPORT_IN_LIMIT.contains((Object)c.dialect()));
    }

    static final boolean transformInlineCTE(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformInlineCTE", configuration.settings().getTransformInlineCTE(), c -> NO_SUPPORT_CTE.contains((Object)c.dialect()));
    }

    static final boolean transformQualify(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformQualify", configuration.settings().getTransformQualify(), c -> EMULATE_QUALIFY.contains((Object)c.dialect()));
    }

    static final boolean transformRownum(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformRownum", configuration.settings().getTransformRownum(), c -> EMULATE_ROWNUM.contains((Object)c.dialect()));
    }

    static final boolean transformAppendMissingTableReferences(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformAppendMissingTableReferences", configuration.settings().getParseAppendMissingTableReferences(), c -> SUPPORT_MISSING_TABLE_REFERENCES.contains((Object)c.settings().getParseDialect()));
    }

    static final boolean transformGroupByColumnIndex(Configuration configuration) {
        return Transformations.transform(configuration, "Settings.transformGroupByColumnIndex", configuration.settings().getTransformGroupByColumnIndex(), c -> EMULATE_GROUP_BY_COLUMN_INDEX.contains((Object)c.dialect()));
    }

    static final boolean transform(Configuration configuration, String label, Transformation transformation, Predicate<? super Configuration> whenNeeded) {
        return (switch (StringUtils.defaultIfNull(transformation, Transformation.WHEN_NEEDED)) {
            case Transformation.NEVER -> false;
            case Transformation.ALWAYS -> true;
            case Transformation.WHEN_NEEDED -> whenNeeded.test(configuration);
            default -> throw new IllegalStateException("Transformation configuration not supported: " + String.valueOf((Object)transformation));
        }) && configuration.requireCommercial(() -> "SQL transformation " + label + " required. SQL transformations are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
    }
}

