/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractQueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;

final class TupleImpl2<Q1 extends QueryPart, Q2 extends QueryPart>
extends AbstractQueryPart
implements QOM.Tuple2<Q1, Q2> {
    private final Q1 part1;
    private final Q2 part2;

    TupleImpl2(Q1 part1, Q2 part2) {
        this.part1 = part1;
        this.part2 = part2;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.sql('(').visit((QueryPart)this.part1).sql(", ").visit((QueryPart)this.part2).sql(')');
    }

    @Override
    public final Q1 $1() {
        return this.part1;
    }

    @Override
    public final Q2 $2() {
        return this.part2;
    }

    @Override
    public final QOM.Tuple2<Q1, Q2> $1(Q1 newPart1) {
        return QOM.tuple(newPart1, this.part2);
    }

    @Override
    public final QOM.Tuple2<Q1, Q2> $2(Q2 newPart2) {
        return QOM.tuple(this.part1, newPart2);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.part1, this.part2);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleImpl2 other = (TupleImpl2)obj;
        return Objects.equals(this.part1, other.part1) && Objects.equals(this.part2, other.part2);
    }
}

