/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Case;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesCreate;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesMatch;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesMerge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesRelationships;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesReturning;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Finish;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListOperator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyContainer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipChain;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ResultStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Configuration;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Dialect;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.GeneralizedRenderer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Renderer;
import org.neo4j.jdbc.internal.shaded.jooq.Asterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Condition;
import org.neo4j.jdbc.internal.shaded.jooq.CreateTableElementListStep;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.DatePart;
import org.neo4j.jdbc.internal.shaded.jooq.False;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.FieldOrRow;
import org.neo4j.jdbc.internal.shaded.jooq.FieldOrRowOrSelect;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Named;
import org.neo4j.jdbc.internal.shaded.jooq.Null;
import org.neo4j.jdbc.internal.shaded.jooq.Param;
import org.neo4j.jdbc.internal.shaded.jooq.Parser;
import org.neo4j.jdbc.internal.shaded.jooq.QualifiedAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Query;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.SelectField;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.SortField;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.True;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ParserException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.translator.impl.ParameterNameGenerator;
import org.neo4j.jdbc.translator.impl.SqlToCypherConfig;
import org.neo4j.jdbc.translator.impl.ViewDefinitionReader;
import org.neo4j.jdbc.translator.spi.Cache;
import org.neo4j.jdbc.translator.spi.Translator;
import org.neo4j.jdbc.translator.spi.View;

final class SqlToCypher
implements Translator {
    static final Pattern ELEMENT_ID_PATTERN = Pattern.compile("(?i)v\\$(?:(?<prefix>.+?)_)?id");
    static final Pattern LIMIT_STAR_FROM_PATTERN = Pattern.compile("\\((\\d+) \\* FROM\\)");
    static final String ELEMENT_ID_FUNCTION_NAME = "elementId";
    static final String ELEMENT_ID_ALIAS = "v$id";
    static final Pattern PERCENT_OR_UNDERSCORE = Pattern.compile("[%_]");
    static final String PROPERTIES = "properties";
    static final String NODE_NAME_START = "_start";
    static final String NODE_NAME_END = "_end";
    static final String NG_START = "start";
    static final String NG_RELTYPE = "reltype";
    static final String NG_END = "end";
    static final Literal<String> LOOKUP_START = Cypher.literalOf("start");
    static final Literal<String> LOOKUP_REL = Cypher.literalOf("rel");
    static final Literal<String> LOOKUP_END = Cypher.literalOf("end");
    private static final Map<String, String> FUNCTION_MAPPING;
    private static final int STATEMENT_CACHE_SIZE = 64;
    private final SqlToCypherConfig config;
    private final Configuration rendererConfig;
    private final Cache<Query, String> cache = Cache.getInstance(64);
    private final Map<String, View> views;
    private volatile DSLContext dslContext;

    static Translator defaultTranslator() {
        return new SqlToCypher(SqlToCypherConfig.defaultConfig());
    }

    static Translator with(SqlToCypherConfig config) {
        return new SqlToCypher(config);
    }

    private SqlToCypher(SqlToCypherConfig config) {
        this.config = config;
        this.rendererConfig = Configuration.newConfig().withPrettyPrint(this.config.isPrettyPrint()).alwaysEscapeNames(this.config.isAlwaysEscapeNames()).withDialect(Dialect.NEO4J_5).build();
        if (this.config.getViewDefinitions() == null) {
            this.views = Map.of();
        } else {
            try {
                this.views = ViewDefinitionReader.of(this.config.getViewDefinitions()).read().stream().collect(Collectors.toMap(View::name, Function.identity()));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DSLContext getDSLContext() {
        DSLContext rv = this.dslContext;
        if (rv == null) {
            SqlToCypher sqlToCypher = this;
            synchronized (sqlToCypher) {
                rv = this.dslContext;
                if (rv == null) {
                    rv = this.dslContext = this.createDSLContext();
                }
            }
        }
        return rv;
    }

    @Override
    public void flushCache() {
        this.cache.flush();
    }

    @Override
    public int getOrder() {
        return Optional.ofNullable(this.config.getPrecedence()).orElseGet(() -> Translator.super.getOrder());
    }

    @Override
    public Set<View> getViews() {
        return Set.copyOf(this.views.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String translate(String sql, DatabaseMetaData optionalDatabaseMetaData) {
        Query query;
        try {
            DSLContext dsl = this.getDSLContext();
            Parser parser = dsl.parser();
            query = parser.parseQuery(sql);
            if (query == null && sql != null && sql.trim().startsWith("//")) {
                return Renderer.getRenderer(this.rendererConfig, GeneralizedRenderer.class).render(Finish.create());
            }
        }
        catch (ParserException pe) {
            throw new IllegalArgumentException(pe);
        }
        if (this.config.isCacheEnabled()) {
            SqlToCypher sqlToCypher = this;
            synchronized (sqlToCypher) {
                return this.cache.computeIfAbsent(query, key -> this.translate0(query, optionalDatabaseMetaData));
            }
        }
        return this.translate0(query, optionalDatabaseMetaData);
    }

    private String translate0(Query query, DatabaseMetaData databaseMetaData) {
        return this.render(ContextAwareStatementBuilder.build(this.config, this.getDSLContext(), databaseMetaData, query, this.views));
    }

    private DSLContext createDSLContext() {
        Settings settings = this.config.asSettings();
        Optional.ofNullable(this.config.getParseNamedParamPrefix()).filter(Predicate.not(String::isBlank)).map(String::trim).ifPresent(settings::withParseNamedParamPrefix);
        DSLContext context = DSL.using(this.config.getSqlDialect(), settings);
        context.configuration().set(() -> {
            HashMap tables = new HashMap();
            this.config.getJoinColumnsToTypeMappings().forEach((k, v) -> {
                String[] tableAndColumnName = k.split("\\.");
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(tableAndColumnName[0], DSL::createTable);
                createTableStep.column(DSL.field(tableAndColumnName[1]).comment("type=" + v));
            });
            this.config.getTableToLabelMappings().forEach((k, v) -> {
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(k, DSL::createTable);
                createTableStep.comment("label=" + v);
            });
            return context.meta((Query[])tables.values().toArray(Query[]::new));
        });
        return context;
    }

    private String render(Statement statement) {
        return Renderer.getRenderer(this.rendererConfig).render(statement);
    }

    static {
        Logger.getLogger("org.neo4j.jdbc.internal.shaded.jooq.Constants").setLevel(Level.WARNING);
        Logger.getLogger("org.neo4j.jdbc.internal.shaded.jooq.Constants").setLevel(Level.WARNING);
        System.setProperty("org.neo4j.jdbc.internal.shaded.jooq.no-logo", "true");
        System.setProperty("org.neo4j.jdbc.internal.shaded.jooq.no-tips", "true");
        FUNCTION_MAPPING = Map.of("strpos", "apoc.text.indexOf");
    }

    static class ContextAwareStatementBuilder {
        private final Map<Name, Expression> columnsAndValues = new LinkedHashMap<Name, Expression>();
        private final Map<String, AtomicInteger> returnColumns = new HashMap<String, AtomicInteger>();
        private final SqlToCypherConfig config;
        private final DSLContext dslContext;
        private final DatabaseMetaData databaseMetaData;
        private final Map<String, Set<CachedColumn>> columnsCache = new ConcurrentHashMap<String, Set<CachedColumn>>();
        private final ParameterNameGenerator parameterNameGenerator = new ParameterNameGenerator();
        private final List<Table<?>> tables = new ArrayList();
        private final Map<SymbolicName, RelationshipPattern> resolvedRelationships = new HashMap<SymbolicName, RelationshipPattern>();
        private final AtomicBoolean useAliasForVColumn = new AtomicBoolean(true);
        private final Map<String, View> views;
        private final Pattern relationshipPattern;

        static Statement build(SqlToCypherConfig config, DSLContext dslContext, DatabaseMetaData databaseMetaData, Query query, Map<String, View> views) {
            ContextAwareStatementBuilder builder = new ContextAwareStatementBuilder(config, dslContext, databaseMetaData, views);
            if (query instanceof Select) {
                Select s = (Select)query;
                return builder.statement(s);
            }
            if (query instanceof QOM.Delete) {
                QOM.Delete d = (QOM.Delete)query;
                return builder.statement(d);
            }
            if (query instanceof QOM.Truncate) {
                QOM.Truncate t = (QOM.Truncate)query;
                return builder.statement(t);
            }
            if (query instanceof QOM.Insert) {
                QOM.Insert t = (QOM.Insert)query;
                return builder.statement(t);
            }
            if (query instanceof QOM.InsertReturning) {
                QOM.InsertReturning t = (QOM.InsertReturning)query;
                return builder.statement(t.$insert(), t.$returning());
            }
            if (query instanceof QOM.Update) {
                QOM.Update u = (QOM.Update)query;
                return builder.statement(u);
            }
            throw ContextAwareStatementBuilder.unsupported(query);
        }

        ContextAwareStatementBuilder(SqlToCypherConfig config, DSLContext dslContext, DatabaseMetaData databaseMetaData, Map<String, View> views) {
            this.config = config;
            this.dslContext = dslContext;
            this.relationshipPattern = this.config.getRelationshipPattern();
            this.databaseMetaData = databaseMetaData;
            this.views = views;
        }

        private boolean ownsView(CbvPointer cbvPointer) {
            return this.views.containsKey(cbvPointer.viewName());
        }

        private static IllegalArgumentException unsupported(QueryPart p) {
            String typeMsg = p != null ? " (Was of type " + p.getClass().getName() + ")" : "";
            return new IllegalArgumentException("Unsupported SQL expression: " + String.valueOf(p) + typeMsg);
        }

        private static Object[] toPropertyArray(Map<Name, Expression> relProperties) {
            return relProperties.entrySet().stream().flatMap(e -> Stream.of(((Name)e.getKey()).last(), e.getValue())).toArray();
        }

        private static Node nodeWithProperties(Node src, Map<Name, Expression> properties) {
            return (Node)src.withProperties(ContextAwareStatementBuilder.toPropertyArray(properties));
        }

        private static SymbolicName symbolicName(String value) {
            return Cypher.name(value.toLowerCase(Locale.ROOT));
        }

        private static String relationshipTypeName(Field<?> lhsJoinColumn) {
            return Objects.requireNonNull(lhsJoinColumn.getQualifiedName().last()).toUpperCase(Locale.ROOT);
        }

        private Statement statement(QOM.Delete<?> d) {
            this.tables.clear();
            this.tables.add(d.$from());
            this.assertCypherBackedViewUsage("Cypher-backed views cannot be deleted from", this.tables.get(0));
            PatternElement patternElement = this.resolveTableOrJoin(this.tables.get(0)).get(0);
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match(patternElement);
            StatementBuilder.OngoingReadingWithWhere m2 = d.$where() != null ? (StatementBuilder.OngoingReadingWithWhere)m1.where(this.condition(d.$where())) : (StatementBuilder.OngoingReadingWithWhere)((Object)m1);
            return m2.delete(((PropertyContainer)((Object)patternElement)).asExpression()).build();
        }

        private Statement statement(QOM.Truncate<?> t) {
            this.tables.clear();
            this.tables.addAll(t.$table());
            for (Table<?> table : this.tables) {
                this.assertCypherBackedViewUsage("Cypher-backed views cannot be deleted from", table);
            }
            PatternElement pattern = this.resolveTableOrJoin(this.tables.get(0)).get(0);
            if (pattern instanceof Node) {
                Node node = (Node)pattern;
                return Cypher.match(node).detachDelete(node.asExpression()).build();
            }
            if (pattern instanceof Relationship) {
                Relationship rel = (Relationship)pattern;
                return Cypher.match(rel).delete(rel).build();
            }
            throw new IllegalArgumentException("Cannot truncate " + String.valueOf(t.$table()));
        }

        private ResultStatement statement(Select<?> incomingStatement) {
            Select selectStatement;
            QOM.TableAlias tableAlias;
            boolean forceLimit = false;
            Table<Object> table = incomingStatement.$from().$first();
            if (table instanceof QOM.TableAlias && (table = (tableAlias = (QOM.TableAlias)table).$table()) instanceof QOM.DerivedTable) {
                QOM.DerivedTable d = (QOM.DerivedTable)table;
                forceLimit = incomingStatement.$where() != null;
                selectStatement = (Select)d.$arg1();
            } else {
                selectStatement = incomingStatement;
            }
            ArrayList<CbvPointer> cbvs = new ArrayList<CbvPointer>();
            this.tables.clear();
            this.tables.addAll(this.extractQueriedTables(selectStatement, cbvs));
            ContextAwareStatementBuilder.assertEitherCypherBackedViewsOrTables(this.tables, cbvs);
            Supplier<List> resultColumnsSupplier = () -> selectStatement.$select().stream().flatMap(this::expression).toList();
            if (ContextAwareStatementBuilder.limitIsTopNWithAsterisk(selectStatement)) {
                resultColumnsSupplier = () -> List.of(Cypher.asterisk());
            } else if (selectStatement.$from().isEmpty()) {
                return (ResultStatement)Cypher.returning(resultColumnsSupplier.get()).build();
            }
            StatementBuilder.OngoingReading reading = cbvs.isEmpty() ? this.createOngoingReadingFromSources(selectStatement) : this.createOngoingReadingFromViews(selectStatement, cbvs);
            StatementBuilder.OngoingReadingAndReturn projection = selectStatement.$distinct() ? reading.returningDistinct(resultColumnsSupplier.get()) : reading.returning(resultColumnsSupplier.get());
            StatementBuilder.OngoingMatchAndReturnWithOrder orderedProjection = projection.orderBy(selectStatement.$orderBy().stream().map(this::expression).toList());
            return this.addLimit(forceLimit, selectStatement, orderedProjection).build();
        }

        private StatementBuilder.BuildableStatement<ResultStatement> addLimit(boolean force, Select<?> selectStatement, StatementBuilder.OngoingMatchAndReturnWithOrder projection) {
            StatementBuilder.OngoingMatchAndReturnWithOrder buildableStatement;
            Field<Number> field = selectStatement.$limit();
            if (!(field instanceof Param)) {
                boolean forceLimit = force;
                String sql = Optional.ofNullable(selectStatement.$limit()).map(Object::toString).orElse("");
                Matcher matcher = LIMIT_STAR_FROM_PATTERN.matcher(sql);
                int limit = 1;
                if (matcher.matches()) {
                    forceLimit = true;
                    limit = Integer.parseInt(matcher.group(1));
                }
                buildableStatement = forceLimit ? projection.limit(limit) : projection;
            } else {
                Param param = (Param)field;
                buildableStatement = projection.limit(this.expression(param));
            }
            return buildableStatement;
        }

        private StatementBuilder.OngoingReading createOngoingReadingFromViews(Select<?> selectStatement, ArrayList<CbvPointer> cbvs) {
            StatementBuilder.OrderableOngoingReadingAndWith m1 = null;
            ArrayList<IdentifiableElement> previousAliases = new ArrayList<IdentifiableElement>();
            for (CbvPointer cbv : cbvs) {
                View view = this.views.get(cbv.viewName());
                MapExpression projection = Cypher.mapOf(view.columns().stream().flatMap(column -> Stream.of(column.name(), Cypher.raw(column.propertyName(), new Object[0]))).toArray());
                previousAliases.add(projection.as(cbv.alias()));
                if (m1 == null) {
                    m1 = Cypher.callRawCypher(view.query(), new Object[0]).with(previousAliases);
                    continue;
                }
                m1 = m1.callRawCypher(view.query(), new Object[0]).with(previousAliases);
            }
            return selectStatement.$where() != null ? ((StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere)Objects.requireNonNull(m1)).where(this.condition(selectStatement.$where())) : m1;
        }

        private StatementBuilder.OngoingReading createOngoingReadingFromSources(Select<?> selectStatement) {
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match(ContextAwareStatementBuilder.getFromClause(selectStatement).stream().flatMap(t -> this.resolveTableOrJoin((Table<?>)t).stream()).toList());
            StatementBuilder.OngoingReadingWithWhere m2 = selectStatement.$where() != null ? (StatementBuilder.OngoingReading)m1.where(this.condition(selectStatement.$where())) : (StatementBuilder.OngoingReadingWithWhere)((Object)m1);
            return m2;
        }

        private static boolean limitIsTopNWithAsterisk(Select<?> selectStatement) {
            return selectStatement.$limit() != null && DSL.systemName("mul").equals(selectStatement.$limit().$name());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static List<? extends Table<?>> getFromClause(Select<?> selectStatement) {
            SelectFieldOrAsterisk selectFieldOrAsterisk;
            void var1_7;
            if (selectStatement.$from().isEmpty() && selectStatement.$limit() != null) {
                SelectFieldOrAsterisk selectFieldOrAsterisk2 = selectStatement.$select().$first();
                if (selectFieldOrAsterisk2 instanceof TableField) {
                    TableField tableField = (TableField)selectFieldOrAsterisk2;
                    List<Table<Record>> list = List.of(DSL.table(tableField.$name()));
                    return var1_7;
                } else {
                    selectFieldOrAsterisk2 = selectStatement.$select().$first();
                    if (!(selectFieldOrAsterisk2 instanceof QOM.FieldAlias)) throw new IllegalStateException("No source table found");
                    QOM.FieldAlias fieldAlias = (QOM.FieldAlias)selectFieldOrAsterisk2;
                    List<SelectField> list = List.of(DSL.table(fieldAlias.$aliased().$name()).as(fieldAlias.$alias()));
                }
                return var1_7;
            } else if (selectStatement.$from().isEmpty() && selectStatement.$limit() != null && (selectFieldOrAsterisk = selectStatement.$select().$first()) instanceof TableField) {
                TableField tableField = (TableField)selectFieldOrAsterisk;
                List<Table<Record>> list = List.of(DSL.table(tableField.$name()));
                return var1_7;
            } else {
                QOM.UnmodifiableList<Table<?>> unmodifiableList = selectStatement.$from();
            }
            return var1_7;
        }

        private static void assertEitherCypherBackedViewsOrTables(List<Table<?>> tables, List<CbvPointer> cbvs) {
            if (!cbvs.isEmpty() && cbvs.size() < tables.size()) {
                throw new IllegalArgumentException("Cypher-backed views cannot be combined with regular tables");
            }
        }

        private List<? extends Table<?>> extractQueriedTables(Select<?> src, List<CbvPointer> cbvs) {
            Set<String> allCbvs = this.loadCypherBackedViews();
            return ContextAwareStatementBuilder.unnestFromClause(ContextAwareStatementBuilder.getFromClause(src), false, (table, partOfJoin) -> {
                CbvPointer p = CbvPointer.of(table);
                if (allCbvs.contains(p.viewName()) && this.ownsView(p)) {
                    if (partOfJoin.booleanValue()) {
                        throw new IllegalArgumentException("Cypher-backed views cannot be used with a JOIN clause");
                    }
                    cbvs.add(p);
                }
            });
        }

        private Set<String> loadCypherBackedViews() {
            if (this.databaseMetaData == null) {
                return Set.of();
            }
            HashSet<String> allCbvs = new HashSet<String>();
            try (ResultSet resultSet = this.databaseMetaData.getTables(null, null, null, new String[]{"CBV"});){
                while (resultSet.next()) {
                    allCbvs.add(resultSet.getString("TABLE_NAME"));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return allCbvs;
        }

        private Statement statement(QOM.Insert<?> insert) {
            return this.statement(insert, List.of());
        }

        private Statement statement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning) {
            boolean useMerge;
            this.tables.clear();
            this.tables.add(insert.$into());
            this.assertCypherBackedViewUsage("Cypher-backed views cannot be inserted to", this.tables.get(0));
            PatternElement target = this.resolveTableOrJoin(this.tables.get(0)).get(0);
            boolean hasMergeProperties = !insert.$onConflict().isEmpty();
            boolean bl = useMerge = insert.$onDuplicateKeyIgnore() || hasMergeProperties;
            if (target instanceof Relationship) {
                Relationship relationship = (Relationship)target;
                if (useMerge) {
                    throw new UnsupportedOperationException("`ON DUPLICATE` and `ON CONFLICT` clauses are not supported for inserting relationships");
                }
                return insert.$values().size() != 1 ? this.buildUnwindCreateStatement(insert, returning, relationship) : this.buildSingleCreateStatement(insert, returning, relationship);
            }
            if (target instanceof Node) {
                Node node = (Node)target;
                return insert.$values().size() != 1 ? this.buildUnwindCreateStatement(insert, returning, node, useMerge, hasMergeProperties) : this.buildSingleCreateStatement(insert, returning, node, useMerge, hasMergeProperties);
            }
            throw new IllegalArgumentException("Cannot determine insertion target from " + target.getClass().getName());
        }

        private Statement buildSingleCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            Row row = Objects.requireNonNull(insert.$values().$first());
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            LinkedHashMap<Name, Expression> nodeProperties = new LinkedHashMap<Name, Expression>();
            for (int i = 0; i < columns.size(); ++i) {
                nodeProperties.put(((Field)columns.get(i)).$name(), this.expression(row.field(i)));
            }
            if (useMerge) {
                LinkedHashMap<Name, Expression> mergeProperties = hasMergeProperties ? new LinkedHashMap<Name, Expression>() : nodeProperties;
                insert.$onConflict().stream().map(Named::$name).forEach(name -> {
                    mergeProperties.put((Name)name, (Expression)nodeProperties.get(name));
                    nodeProperties.remove(name);
                });
                ArrayList properties = new ArrayList();
                nodeProperties.forEach((k, v) -> properties.add(Cypher.set(node.property(k.last()), v)));
                StatementBuilder.ExposesForeach merge = Cypher.merge(ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties));
                if (hasMergeProperties) {
                    merge = ((StatementBuilder.ExposesMergeAction)((Object)merge)).onCreate().set(properties);
                }
                if (!insert.$updateSet().isEmpty()) {
                    ArrayList updates = new ArrayList();
                    insert.$updateSet().forEach((c, v) -> {
                        ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                        synchronized (contextAwareStatementBuilder) {
                            try {
                                this.columnsAndValues.putAll(nodeProperties);
                                updates.add(Cypher.set(node.property(((Field)c).getName()), this.expression((Field)v)));
                            }
                            finally {
                                nodeProperties.keySet().forEach(this.columnsAndValues::remove);
                            }
                        }
                    });
                    merge = ((StatementBuilder.ExposesMergeAction)((Object)merge)).onMatch().set(updates);
                }
                return this.addOptionalReturnAndBuild((ExposesReturning)((Object)merge), returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.create(ContextAwareStatementBuilder.nodeWithProperties(node, nodeProperties)), returning);
        }

        private Statement buildSingleCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Relationship relationship) {
            StatementBuilder.ExposesForeach ongoingUpdate;
            this.useAliasForVColumn.set(false);
            Expression[] row = this.expression(Objects.requireNonNull(insert.$values().$first()));
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            HashSet<Name> used = new HashSet<Name>();
            Map<Name, Expression> lhsProperties = this.getPropertiesFor(row, columns, relationship.getLeft(), used);
            used.addAll(lhsProperties.keySet());
            Map<Name, Expression> rhsProperties = this.getPropertiesFor(row, columns, relationship.getRight(), used);
            used.addAll(rhsProperties.keySet());
            Map<Name, Expression> relProperties = this.getPropertiesFor(row, columns, relationship, used);
            used.addAll(relProperties.keySet());
            Node left = ContextAwareStatementBuilder.nodeWithProperties(relationship.getLeft(), lhsProperties);
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition leftCondition = Cypher.noCondition();
            Node right = ContextAwareStatementBuilder.nodeWithProperties(relationship.getRight(), rhsProperties);
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition rightCondition = Cypher.noCondition();
            List<String> virtualIdColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(relationship)).stream().filter(CachedColumn::isGenerated).map(CachedColumn::name).toList();
            Set<CachedColumn> relationshipColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(relationship));
            for (int i = 0; i < columns.size(); ++i) {
                Name targetColumn = ((Field)columns.get(i)).$name();
                boolean isVirtualId = virtualIdColumns.contains(targetColumn.last());
                if (isVirtualId && ContextAwareStatementBuilder.isVirtualIdColumnForNode(left, targetColumn.last())) {
                    leftCondition = leftCondition.and(Cypher.elementId(left).eq(row[i]));
                    continue;
                }
                if (isVirtualId && ContextAwareStatementBuilder.isVirtualIdColumnForNode(right, targetColumn.last())) {
                    rightCondition = rightCondition.and(Cypher.elementId(right).eq(row[i]));
                    continue;
                }
                if (lhsProperties.containsKey(targetColumn) || rhsProperties.containsKey(targetColumn)) continue;
                if (relationshipColumns.stream().anyMatch(c -> ContextAwareStatementBuilder.label(relationship.getLeft()).equals(c.scopeTable) && c.name().equals(targetColumn.last()))) {
                    leftCondition = leftCondition.and(this.expression((Field)columns.get(i)).eq(row[i]));
                    continue;
                }
                if (relationshipColumns.stream().anyMatch(c -> ContextAwareStatementBuilder.label(relationship.getRight()).equals(c.scopeTable) && c.name().equals(targetColumn.last()))) {
                    rightCondition = rightCondition.and(this.expression((Field)columns.get(i)).eq(row[i]));
                    continue;
                }
                relProperties.putIfAbsent(targetColumn, row[i]);
            }
            this.useAliasForVColumn.compareAndSet(false, true);
            Relationship newRelationship = (Relationship)((Relationship)left.relationshipTo(right, relationship.getDetails().getTypes().get(0))).withProperties(ContextAwareStatementBuilder.toPropertyArray(relProperties));
            if (leftCondition != Cypher.noCondition()) {
                ongoingUpdate = Cypher.match(left.where(leftCondition));
            } else {
                ExposesReturning exposesReturning = ongoingUpdate = lhsProperties.isEmpty() ? Cypher.create(left) : Cypher.merge(left);
            }
            ongoingUpdate = rightCondition != Cypher.noCondition() ? ((ExposesMatch)((Object)ongoingUpdate)).match(right.where(rightCondition)) : (rhsProperties.isEmpty() ? ((ExposesCreate)((Object)ongoingUpdate)).create(right) : ((ExposesMerge)((Object)ongoingUpdate)).merge(right));
            return this.addOptionalReturnAndBuild(((ExposesCreate)((Object)ongoingUpdate)).create(newRelationship), returning);
        }

        private Map<Name, Expression> getPropertiesFor(Expression[] row, List<? extends Field<?>> targetColumns, PatternElement targetElement, Set<Name> used) {
            Set<CachedColumn> columns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(targetElement));
            String targetLabelOrType = targetElement instanceof Relationship ? ((Relationship)targetElement).getDetails().getTypes().get(0) : ContextAwareStatementBuilder.toTableName(targetElement);
            LinkedHashMap<Name, Expression> targetProperties = new LinkedHashMap<Name, Expression>();
            for (int i = 0; i < targetColumns.size(); ++i) {
                boolean directInsert;
                Name targetColumn = targetColumns.get(i).$name();
                String columnTargetTable = targetColumns.get(i).$name().first();
                Optional<CachedColumn> cachedColumn = columns.stream().filter(c -> c.name().equals(targetColumn.last()) && !c.isGenerated()).findFirst();
                boolean unqualified = !targetColumns.get(i).$name().qualified();
                boolean bl = directInsert = !unqualified && targetLabelOrType.equalsIgnoreCase(columnTargetTable);
                if (directInsert) {
                    targetProperties.put(targetColumn, row[i]);
                    continue;
                }
                if (!unqualified || !cachedColumn.isPresent() || used.contains(targetColumn) || !targetProperties.keySet().stream().map(Name::last).filter(Objects::nonNull).noneMatch(last -> last.equalsIgnoreCase(targetColumn.last()))) continue;
                targetProperties.put(targetColumn, row[i]);
            }
            return targetProperties;
        }

        private Set<CachedColumn> getColumnsOf(String targetLabel) {
            return this.columnsCache.computeIfAbsent(targetLabel, key -> {
                LinkedHashSet<CachedColumn> value = new LinkedHashSet<CachedColumn>();
                if (this.databaseMetaData != null) {
                    try (ResultSet rs = this.databaseMetaData.getColumns(null, null, targetLabel, null);){
                        while (rs.next()) {
                            value.add(new CachedColumn(rs.getString("COLUMN_NAME"), "YES".equalsIgnoreCase(rs.getString("IS_GENERATEDCOLUMN")), rs.getString("SCOPE_TABLE")));
                        }
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                return value;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Statement buildUnwindCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            if (useMerge && !hasMergeProperties) {
                throw new UnsupportedOperationException("`ON DUPLICATE` and `ON CONFLICT` clauses are not supported when inserting multiple rows without using a property to merge on");
            }
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            ListExpression props = Cypher.listOf(insert.$values().stream().map(row -> {
                HashMap<String, Expression> result = new HashMap<String, Expression>(columns.size());
                for (int i = 0; i < columns.size(); ++i) {
                    result.put(((Field)columns.get(i)).getName(), this.expression(row.field(i)));
                }
                return Cypher.literalOf(result);
            }).toList());
            if (useMerge) {
                SymbolicName symName = Cypher.name(SqlToCypher.PROPERTIES);
                LinkedHashMap<Name, Expression> mergeProperties = new LinkedHashMap<Name, Expression>();
                insert.$onConflict().forEach(c -> mergeProperties.put(c.$name(), Cypher.property((Expression)symName, Cypher.literalOf(c.getName()))));
                ArrayList properties = new ArrayList();
                columns.stream().filter(c -> !mergeProperties.containsKey(c.$name())).forEach(c -> properties.add(Cypher.set(node.property(c.getName()), Cypher.property((Expression)symName, c.getName()))));
                ArrayList updates = new ArrayList();
                ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                synchronized (contextAwareStatementBuilder) {
                    try {
                        columns.forEach(c -> this.columnsAndValues.put(c.$name(), Cypher.property((Expression)symName, Cypher.literalOf(c.getName()))));
                        insert.$updateSet().forEach((c, v) -> updates.add(Cypher.set(node.property(((Field)c).getName()), this.expression((Field)v))));
                    }
                    finally {
                        columns.forEach(c -> this.columnsAndValues.remove(c.$name()));
                    }
                }
                return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as(SqlToCypher.PROPERTIES).merge(ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties)).onCreate().set(properties).onMatch().set(updates), returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as(SqlToCypher.PROPERTIES).create(node).set(node, (Expression)Cypher.name(SqlToCypher.PROPERTIES)), returning);
        }

        private Statement buildUnwindCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Relationship relationship) {
            this.useAliasForVColumn.set(false);
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            List<String> virtualIdColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(relationship)).stream().filter(CachedColumn::isGenerated).map(CachedColumn::name).toList();
            HashSet<Name> leftMergeProperties = new HashSet<Name>();
            HashSet<Name> rightMergeProperties = new HashSet<Name>();
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition leftCondition = null;
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition rightCondition = null;
            SymbolicName propertiesName = Cypher.name(SqlToCypher.PROPERTIES);
            ArrayList list = new ArrayList();
            for (Row values : insert.$values()) {
                Expression[] row = this.expression(values);
                LinkedHashMap<String, Map> allPropertiesInRow = new LinkedHashMap<String, Map>();
                HashSet<Name> used = new HashSet<Name>();
                Map<Name, Expression> lhsProperties = this.getPropertiesFor(row, columns, relationship.getLeft(), used);
                used.addAll(lhsProperties.keySet());
                Map<Name, Expression> rhsProperties = this.getPropertiesFor(row, columns, relationship.getRight(), used);
                used.addAll(rhsProperties.keySet());
                Map<Name, Expression> relProperties = this.getPropertiesFor(row, columns, relationship, used);
                used.addAll(relProperties.keySet());
                if (leftMergeProperties.isEmpty()) {
                    leftMergeProperties.addAll(lhsProperties.keySet());
                } else {
                    leftMergeProperties.retainAll(lhsProperties.keySet());
                }
                if (rightMergeProperties.isEmpty()) {
                    rightMergeProperties.addAll(rhsProperties.keySet());
                } else {
                    rightMergeProperties.retainAll(rhsProperties.keySet());
                }
                Set<CachedColumn> relationshipColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(relationship));
                Name elementId = this.dslContext.parser().parseName("_elementId");
                for (int i = 0; i < columns.size(); ++i) {
                    Name targetColumn = ((Field)columns.get(i)).$name();
                    boolean isVirtualId = virtualIdColumns.contains(targetColumn.last());
                    if (isVirtualId && ContextAwareStatementBuilder.isVirtualIdColumnForNode(relationship.getLeft(), targetColumn.last())) {
                        lhsProperties.put(elementId, row[i]);
                        leftCondition = Cypher.elementId(relationship.getLeft()).eq(ContextAwareStatementBuilder.lookupElementIdOf(propertiesName, LOOKUP_START));
                        continue;
                    }
                    if (isVirtualId && ContextAwareStatementBuilder.isVirtualIdColumnForNode(relationship.getRight(), targetColumn.last())) {
                        rhsProperties.put(elementId, row[i]);
                        rightCondition = Cypher.elementId(relationship.getRight()).eq(ContextAwareStatementBuilder.lookupElementIdOf(propertiesName, LOOKUP_END));
                        continue;
                    }
                    if (lhsProperties.containsKey(targetColumn) || rhsProperties.containsKey(targetColumn)) continue;
                    if (leftCondition == null && relationshipColumns.stream().anyMatch(c -> ContextAwareStatementBuilder.label(relationship.getLeft()).equals(c.scopeTable) && c.name().equals(targetColumn.last()))) {
                        leftCondition = this.expression((Field)columns.get(i)).eq(row[i]);
                        continue;
                    }
                    if (rightCondition == null && relationshipColumns.stream().anyMatch(c -> ContextAwareStatementBuilder.label(relationship.getRight()).equals(c.scopeTable) && c.name().equals(targetColumn.last()))) {
                        rightCondition = this.expression((Field)columns.get(i)).eq(row[i]);
                        continue;
                    }
                    relProperties.putIfAbsent(targetColumn, row[i]);
                }
                Collector<Map.Entry, ?, Map> mappingCollector = Collectors.toMap(e -> ((Name)e.getKey()).last(), Map.Entry::getValue, (x, y) -> {
                    throw new IllegalStateException("Duplicate map key");
                }, LinkedHashMap::new);
                allPropertiesInRow.put(LOOKUP_START.getContent(), lhsProperties.entrySet().stream().collect(mappingCollector));
                allPropertiesInRow.put(LOOKUP_REL.getContent(), relProperties.entrySet().stream().collect(mappingCollector));
                allPropertiesInRow.put(LOOKUP_END.getContent(), rhsProperties.entrySet().stream().collect(mappingCollector));
                Literal apply = Cypher.literalOf(allPropertiesInRow);
                list.add(apply);
            }
            ListExpression properties = Cypher.listOf(list);
            this.useAliasForVColumn.compareAndSet(false, true);
            if (leftMergeProperties.isEmpty() && rightMergeProperties.isEmpty() && leftCondition == null && rightCondition == null) {
                return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)properties).as(propertiesName).create(relationship).set(relationship.getLeft(), (Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_START)).set(relationship, (Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_REL)).set((org.neo4j.jdbc.internal.shaded.cypherdsl.Named)relationship.getRight(), (Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_END)), returning);
            }
            StatementBuilder.ExposesForeach ongoingStratement = Cypher.unwind((Expression)properties).as(propertiesName);
            if (leftCondition != null) {
                ongoingStratement = ((ExposesMatch)((Object)ongoingStratement)).match(relationship.getLeft().where(leftCondition));
            } else if (leftMergeProperties.isEmpty()) {
                ongoingStratement = ((ExposesCreate)((Object)ongoingStratement)).create(relationship.getLeft());
            } else {
                Node left = (Node)relationship.getLeft().withProperties(leftMergeProperties.stream().flatMap(k -> Stream.of(k.last(), Cypher.valueAt((Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_START), Cypher.literalOf(k.last())))).toArray(Object[]::new));
                ongoingStratement = ((ExposesMerge)((Object)ongoingStratement)).merge(left);
            }
            if (rightCondition != null) {
                ongoingStratement = ((ExposesMatch)((Object)ongoingStratement)).match(relationship.getRight().where(rightCondition));
            } else if (rightMergeProperties.isEmpty()) {
                ongoingStratement = ((ExposesCreate)((Object)ongoingStratement)).create(relationship.getRight());
            } else {
                Node right = (Node)relationship.getRight().withProperties(rightMergeProperties.stream().flatMap(k -> Stream.of(k.last(), Cypher.valueAt((Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_END), Cypher.literalOf(k.last())))).toArray(Object[]::new));
                ongoingStratement = ((ExposesMerge)((Object)ongoingStratement)).merge(right);
            }
            return this.addOptionalReturnAndBuild(((ExposesCreate)((Object)ongoingStratement)).create(relationship).set(relationship, (Expression)Cypher.valueAt((Expression)propertiesName, LOOKUP_REL)), returning);
        }

        private static ListOperator lookupElementIdOf(SymbolicName propertiesName, Literal<String> side) {
            return Cypher.valueAt((Expression)Cypher.valueAt((Expression)propertiesName, side), Cypher.literalOf("_elementId"));
        }

        private <T extends ExposesReturning & StatementBuilder.BuildableStatement<?>> Statement addOptionalReturnAndBuild(T exposesReturning, List<? extends SelectFieldOrAsterisk> returning) {
            if (returning == null || returning.isEmpty()) {
                return ((StatementBuilder.BuildableStatement<?>)exposesReturning).build();
            }
            return exposesReturning.returning(returning.stream().flatMap(this::expression).toList()).build();
        }

        private String uniqueColumnName(String s) {
            int cnt = this.returnColumns.computeIfAbsent(s, k -> new AtomicInteger(0)).getAndAccumulate(1, Integer::sum);
            return s + String.valueOf(cnt > 0 ? Integer.valueOf(cnt) : "");
        }

        private Statement statement(QOM.Update<?> update) {
            ExposesRelationships<Relationship> target;
            this.tables.clear();
            this.tables.add(update.$table());
            this.assertCypherBackedViewUsage("Cypher-backed views cannot be updated", this.tables.get(0));
            ArrayList updates = new ArrayList();
            PatternElement patternElement = this.resolveTableOrJoin(this.tables.get(0)).get(0);
            if (patternElement instanceof Node) {
                Node n;
                target = n = (Node)patternElement;
            } else if (patternElement instanceof Relationship) {
                Relationship r = (Relationship)patternElement;
                for (PatternElement targetElement : new PatternElement[]{r.getLeft(), r, r.getRight()}) {
                    Set columns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(targetElement)).stream().map(CachedColumn::name).collect(Collectors.toSet());
                    String targetLabelOrType = targetElement instanceof Relationship ? ((Relationship)targetElement).getDetails().getTypes().get(0) : ContextAwareStatementBuilder.toTableName(targetElement);
                    update.$set().forEach((c, v) -> {
                        String name = ((Field)c).getName();
                        if (columns.contains(name) || targetLabelOrType.equals(((Field)c).$name().first())) {
                            updates.add(((PropertyContainer)((Object)targetElement)).property(name));
                            updates.add(this.expression((Field)v));
                        }
                    });
                }
                target = updates.isEmpty() ? r : null;
            } else {
                throw ContextAwareStatementBuilder.unsupported(update);
            }
            if (target != null) {
                update.$set().forEach((arg_0, arg_1) -> this.lambda$statement$3(updates, (PropertyContainer)((Object)target), arg_0, arg_1));
            }
            StatementBuilder.ExposesSet exposesSet = update.$where() != null ? (StatementBuilder.ExposesSet)Cypher.match(patternElement).where(this.condition(update.$where())) : Cypher.match(patternElement);
            return exposesSet.set(updates).build();
        }

        private void assertCypherBackedViewUsage(String s, Table<?> table) {
            CbvPointer p;
            Set<String> allCbvs = this.loadCypherBackedViews();
            if (allCbvs.contains((p = CbvPointer.of(table)).viewName()) && this.ownsView(p)) {
                throw new IllegalArgumentException(s);
            }
        }

        private Stream<Expression> expression(SelectFieldOrAsterisk t) {
            QualifiedAsterisk q;
            Object properties2;
            if (t instanceof SelectField) {
                TableField tf;
                SelectField theField;
                SelectField s = (SelectField)t;
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    v0 = fa.$aliased();
                } else {
                    v0 = theField = s;
                }
                Expression col = theField instanceof TableField && (tf = (TableField)theField).getTable() == null ? this.findTableFieldInTables(tf, true, !(s instanceof QOM.FieldAlias)) : this.expression(s);
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    col = col.as(fa.$alias().last());
                }
                return Stream.of(col);
            }
            if (t instanceof Asterisk) {
                List<Expression> properties2 = this.projectAllColumns();
                if (properties2.isEmpty()) {
                    properties2.add(Cypher.asterisk());
                }
                return properties2.stream();
            }
            if (t instanceof QualifiedAsterisk && (properties2 = this.resolveTableOrJoin((q = (QualifiedAsterisk)t).$table()).get(0)) instanceof Node) {
                Node node = (Node)properties2;
                properties2 = new ArrayList();
                for (Table<?> table : this.tables) {
                    QOM.TableAlias tableAlias;
                    if (!(table instanceof QOM.TableAlias) || !(tableAlias = (QOM.TableAlias)table).getName().equals(q.$table().getName())) continue;
                    ((ArrayList)properties2).addAll(this.projectAllColumns(List.of(tableAlias)));
                    break;
                }
                if (((ArrayList)properties2).isEmpty()) {
                    SymbolicName symbolicName = node.getSymbolicName().orElseGet(() -> Cypher.name(q.$table().getName()));
                    ((ArrayList)properties2).add(symbolicName.project(Cypher.asterisk()).as(symbolicName));
                }
                return properties2.stream();
            }
            throw ContextAwareStatementBuilder.unsupported(t);
        }

        private List<Expression> projectAllColumns() {
            return this.projectAllColumns(this.tables);
        }

        private List<Expression> projectAllColumns(List<Table<?>> from) {
            ArrayList<Expression> properties = new ArrayList<Expression>();
            if (this.databaseMetaData == null) {
                return properties;
            }
            for (Table<?> table : from) {
                PropertyContainer pc = (PropertyContainer)((Object)this.resolveTableOrJoin(table).get(0));
                String tableName = this.labelOrType(table);
                if (!(pc instanceof Relationship)) {
                    properties.addAll(this.findProperties(tableName, pc));
                    continue;
                }
                Relationship rel = (Relationship)pc;
                properties.add(this.makeFk(rel.getLeft()));
                properties.addAll(this.findProperties(tableName, pc));
                properties.add(this.makeFk(rel.getRight()));
            }
            return properties;
        }

        private Expression makeFk(Node node) {
            String nodeName = ContextAwareStatementBuilder.label(node);
            return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(SqlToCypher.ELEMENT_ID_FUNCTION_NAME).withArgs(node.asExpression())).asFunction().as(this.uniqueColumnName("v$" + nodeName.toLowerCase(Locale.ROOT) + "_id"));
        }

        private List<Expression> findProperties(String tableName, PropertyContainer pc) {
            ArrayList<Expression> properties = new ArrayList<Expression>();
            if (!this.views.containsKey(tableName)) {
                properties.add(this.makeId(pc, null));
            }
            for (CachedColumn column : this.getColumnsOf(tableName)) {
                if (column.isGenerated()) continue;
                String columnName = column.name();
                PropertyContainer finalContainer = pc;
                if (column.scopeTable() != null && pc instanceof Relationship) {
                    Relationship rel = (Relationship)pc;
                    if (ContextAwareStatementBuilder.isLabelOfNode(rel.getLeft(), column.scopeTable())) {
                        finalContainer = rel.getLeft();
                    } else if (ContextAwareStatementBuilder.isLabelOfNode(rel.getRight(), column.scopeTable())) {
                        finalContainer = rel.getRight();
                    }
                }
                properties.add(finalContainer.property(columnName).as(this.uniqueColumnName(columnName)));
            }
            return properties;
        }

        private Expression makeId(PropertyContainer pc, String alias) {
            Expression function = ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(SqlToCypher.ELEMENT_ID_FUNCTION_NAME).withArgs(pc.asExpression())).asFunction();
            if (this.useAliasForVColumn.get()) {
                return function.as(this.uniqueColumnName(alias != null ? alias : SqlToCypher.ELEMENT_ID_ALIAS));
            }
            return function;
        }

        private static List<? extends Table<?>> unnestFromClause(List<? extends Table<?>> tables, boolean partOfJoin, BiConsumer<Table<?>, Boolean> listener) {
            ArrayList result = new ArrayList();
            for (Table<?> table : tables) {
                if (table instanceof QOM.JoinTable) {
                    QOM.JoinTable join = (QOM.JoinTable)table;
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table1()), true, listener));
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table2()), true, listener));
                    continue;
                }
                result.add(table);
                listener.accept(table, partOfJoin);
            }
            return result;
        }

        private Expression expression(SelectField<?> s) {
            if (s instanceof QOM.FieldAlias) {
                QOM.FieldAlias fa = (QOM.FieldAlias)s;
                return this.expression((Field<?>)fa.$aliased()).as(fa.$alias().last());
            }
            if (s instanceof Field) {
                Field f = (Field)s;
                return this.expression(f);
            }
            throw ContextAwareStatementBuilder.unsupported(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SortItem expression(SortField<?> s) {
            try {
                Expression col;
                String direction;
                block6: {
                    this.useAliasForVColumn.set(false);
                    direction = s.$sortOrder().name().toUpperCase(Locale.ROOT);
                    Field<?> theField = s.$field();
                    col = null;
                    try {
                        col = this.expression(theField);
                    }
                    catch (IllegalArgumentException ex) {
                        TableField tf;
                        if (theField instanceof TableField && (tf = (TableField)theField).getTable() == null) {
                            col = this.findTableFieldInTables(tf, false, false);
                        }
                        if (!(s instanceof QOM.FieldAlias)) break block6;
                        QOM.FieldAlias fa = (QOM.FieldAlias)((Object)s);
                        if (col == null) break block6;
                        col = col.as(fa.$alias().last());
                    }
                }
                SortItem sortItem = Cypher.sort(col, "DEFAULT".equals(direction) ? SortItem.Direction.UNDEFINED : SortItem.Direction.valueOf(direction));
                return sortItem;
            }
            finally {
                this.useAliasForVColumn.set(true);
            }
        }

        private Expression findTableFieldInTables(TableField<?, ?> tf, boolean fallbackToFieldName, boolean doAlias) {
            Property property;
            Object rel;
            Expression col = null;
            if (this.tables.size() == 1) {
                Table<?> theTable = this.tables.get(0);
                PropertyContainer propertyContainer = (PropertyContainer)((Object)this.resolveTableOrJoin(theTable).get(0));
                if (ContextAwareStatementBuilder.isElementId(tf)) {
                    return this.makeId(propertyContainer, tf.getName());
                }
                if (ContextAwareStatementBuilder.isFkId(tf) != null && propertyContainer instanceof Relationship) {
                    rel = (Relationship)propertyContainer;
                    if (ContextAwareStatementBuilder.isVirtualIdColumnForNode(rel.getLeft(), tf.getName())) {
                        return this.makeId(rel.getLeft(), tf.getName());
                    }
                    if (ContextAwareStatementBuilder.isVirtualIdColumnForNode(rel.getRight(), tf.getName())) {
                        return this.makeId(rel.getRight(), tf.getName());
                    }
                }
                col = propertyContainer.getSymbolicName().filter(f -> !f.getValue().equals(tf.getName())).map(__ -> {
                    Property property = propertyContainer.property(tf.getName());
                    if (doAlias) {
                        return property.as(tf.getName());
                    }
                    return property;
                }).orElse(null);
            } else if (this.databaseMetaData != null) {
                boolean isId = ContextAwareStatementBuilder.isElementId(tf);
                String prefix = ContextAwareStatementBuilder.isFkId(tf);
                rel = this.tables.iterator();
                while (rel.hasNext()) {
                    PropertyContainer pc;
                    Table<?> table = rel.next();
                    String tableName = this.labelOrType(table);
                    if (isId) {
                        pc = (PropertyContainer)((Object)this.resolveTableOrJoin(table).get(0));
                        return this.makeId(pc, tf.getName());
                    }
                    if (tableName.equalsIgnoreCase(prefix)) {
                        pc = (PropertyContainer)((Object)this.resolveTableOrJoin(table).get(0));
                        return this.makeId(pc, tf.getName());
                    }
                    try {
                        ResultSet columns = this.databaseMetaData.getColumns(null, null, tableName, null);
                        try {
                            while (columns.next()) {
                                String columnName = columns.getString("COLUMN_NAME");
                                if (!columnName.equals(tf.getName())) continue;
                                PropertyContainer pc2 = (PropertyContainer)((Object)this.resolveTableOrJoin(table).get(0));
                                col = pc2.property(tf.getName());
                            }
                        }
                        finally {
                            if (columns == null) continue;
                            columns.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            if (col == null && fallbackToFieldName) {
                col = Cypher.name(tf.getName());
            }
            if (col instanceof Property && (rel = this.resolvedRelationships.get((property = (Property)col).getContainer().getRequiredSymbolicName())) instanceof Relationship) {
                Relationship rel2 = (Relationship)rel;
                Optional<Expression> optionalScopedColumn = this.findInScopedColumns(rel2, tf);
                if (optionalScopedColumn.isPresent()) {
                    col = optionalScopedColumn.get();
                } else if (this.getColumnsOf(ContextAwareStatementBuilder.toTableName(rel2)).stream().filter(cachedColumn -> cachedColumn.scopeTable() == null).anyMatch(c -> c.name().equals(tf.getName()))) {
                    col = rel2.property(tf.getName());
                } else if (rel2.getLeft().getLabels().stream().map(NodeLabel::getValue).flatMap(t -> this.getColumnsOf((String)t).stream()).anyMatch(c -> c.name().equals(tf.getName()))) {
                    col = rel2.getLeft().property(tf.getName());
                } else if (rel2.getRight().getLabels().stream().map(NodeLabel::getValue).flatMap(t -> this.getColumnsOf((String)t).stream()).anyMatch(c -> c.name().equals(tf.getName()))) {
                    col = rel2.getRight().property(tf.getName());
                }
            }
            return col;
        }

        Optional<Expression> findInScopedColumns(PatternElement pe, TableField<?, ?> tf) {
            if (!(pe instanceof Relationship)) {
                return Optional.empty();
            }
            Relationship rel = (Relationship)pe;
            Set<CachedColumn> relationshipColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(rel));
            Optional<CachedColumn> optionalScopedColumn = relationshipColumns.stream().filter(c -> c.name().equals(tf.getName()) && c.scopeTable() != null).findFirst();
            return optionalScopedColumn.map(scopedColumn -> ContextAwareStatementBuilder.label(rel.getLeft()).equals(scopedColumn.scopeTable()) ? rel.getLeft().property(scopedColumn.unscopedName()) : rel.getRight().property(scopedColumn.unscopedName())).map(p -> this.useAliasForVColumn.get() ? p.as(tf.getName()) : p);
        }

        private Expression[] expression(Row row) {
            Expression[] result = new Expression[row.size()];
            for (int i = 0; i < row.size(); ++i) {
                result[i] = this.expression(row.field(i));
            }
            return result;
        }

        private Expression expression(Field<?> f) {
            return this.expression(f, false);
        }

        private Expression expression(Field<?> f, boolean turnUnknownIntoNames) {
            QOM.ArrayGet g;
            Object Q1;
            QOM.Excluded excluded;
            if (f instanceof Param) {
                Param p = (Param)f;
                if (p.$inline()) {
                    return Cypher.literalOf(p.getValue());
                }
                String parameterName = p.getParamType() == ParamType.INDEXED || p.getParamType() == ParamType.FORCE_INDEXED ? this.parameterNameGenerator.newIndex() : this.parameterNameGenerator.newIndex(p.getParamName());
                return parameterName != null ? Cypher.parameter(parameterName, p.getValue()) : Cypher.anonParameter(p.getValue());
            }
            if (f instanceof TableField) {
                TableField tf = (TableField)f;
                Table table = tf.getTable();
                if (table == null) {
                    Expression tableField = this.findTableFieldInTables(tf, turnUnknownIntoNames, false);
                    if (tableField == null) {
                        throw ContextAwareStatementBuilder.unsupported(tf);
                    }
                    return tableField;
                }
                for (RelationshipPattern relationshipPattern : this.resolvedRelationships.values()) {
                    if (!(relationshipPattern instanceof Relationship)) continue;
                    Relationship rel = (Relationship)relationshipPattern;
                    Predicate<String> labelOrTypePredicate = v -> v.equals(table.getName());
                    if (rel.getLeft().getLabels().stream().map(NodeLabel::getValue).anyMatch(labelOrTypePredicate)) {
                        return rel.getLeft().property(tf.getName());
                    }
                    if (rel.getDetails().getTypes().stream().anyMatch(labelOrTypePredicate)) {
                        return rel.property(tf.getName());
                    }
                    if (!rel.getRight().getLabels().stream().map(NodeLabel::getValue).anyMatch(labelOrTypePredicate)) continue;
                    return rel.getRight().property(tf.getName());
                }
                PatternElement pe = this.resolveTableOrJoin(table).get(0);
                if (pe instanceof PropertyContainer) {
                    PropertyContainer propertyContainer = (PropertyContainer)((Object)pe);
                    Matcher m = ELEMENT_ID_PATTERN.matcher(tf.getName());
                    if (m.matches()) {
                        PropertyContainer src = propertyContainer;
                        String prefix = m.group("prefix");
                        if (propertyContainer instanceof Relationship) {
                            Relationship rel = (Relationship)propertyContainer;
                            if (!"element".equalsIgnoreCase(prefix)) {
                                if (ContextAwareStatementBuilder.label(rel.getLeft()).equalsIgnoreCase(prefix)) {
                                    src = rel.getLeft();
                                } else if (ContextAwareStatementBuilder.label(rel.getRight()).equalsIgnoreCase(prefix)) {
                                    src = rel.getRight();
                                }
                            }
                        }
                        return this.makeId(src, tf.getName());
                    }
                    return this.findInScopedColumns(pe, tf).orElseGet(() -> pc.property(tf.getName()));
                }
                throw ContextAwareStatementBuilder.unsupported(tf);
            }
            if (f instanceof QOM.Add) {
                QOM.Add e = (QOM.Add)f;
                return this.expression((Field)e.$arg1()).add(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Sub) {
                QOM.Sub e = (QOM.Sub)f;
                return this.expression((Field)e.$arg1()).subtract(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Mul) {
                QOM.Mul e = (QOM.Mul)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Square) {
                QOM.Square e = (QOM.Square)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Div) {
                QOM.Div e = (QOM.Div)f;
                return this.expression((Field)e.$arg1()).divide(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Neg) {
                QOM.Neg e = (QOM.Neg)f;
                throw ContextAwareStatementBuilder.unsupported(e);
            }
            if (f instanceof QOM.Abs) {
                QOM.Abs e = (QOM.Abs)f;
                return Cypher.abs(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ceil) {
                QOM.Ceil e = (QOM.Ceil)f;
                return Cypher.ceil(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Floor) {
                QOM.Floor e = (QOM.Floor)f;
                return Cypher.floor(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Round) {
                QOM.Round e = (QOM.Round)f;
                if (e.$arg2() == null) {
                    return Cypher.round(this.expression((Field)e.$arg1()), new Expression[0]);
                }
                return Cypher.round(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Sign) {
                QOM.Sign e = (QOM.Sign)f;
                return Cypher.sign(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Rand) {
                return Cypher.rand();
            }
            if (f instanceof QOM.Euler) {
                return Cypher.e();
            }
            if (f instanceof QOM.Exp) {
                QOM.Exp e = (QOM.Exp)f;
                return Cypher.exp(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ln) {
                QOM.Ln e = (QOM.Ln)f;
                return Cypher.log(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Log) {
                QOM.Log e = (QOM.Log)f;
                return Cypher.log(this.expression((Field)e.$arg1())).divide(Cypher.log(this.expression((Field)e.$arg2())));
            }
            if (f instanceof QOM.Log10) {
                QOM.Log10 e = (QOM.Log10)f;
                return Cypher.log10(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sqrt) {
                QOM.Sqrt e = (QOM.Sqrt)f;
                return Cypher.sqrt(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Acos) {
                QOM.Acos e = (QOM.Acos)f;
                return Cypher.acos(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Asin) {
                QOM.Asin e = (QOM.Asin)f;
                return Cypher.asin(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan) {
                QOM.Atan e = (QOM.Atan)f;
                return Cypher.atan(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan2) {
                QOM.Atan2 e = (QOM.Atan2)f;
                return Cypher.atan2(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Cos) {
                QOM.Cos e = (QOM.Cos)f;
                return Cypher.cos(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Cot) {
                QOM.Cot e = (QOM.Cot)f;
                return Cypher.cot(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Degrees) {
                QOM.Degrees e = (QOM.Degrees)f;
                return Cypher.degrees(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Pi) {
                return Cypher.pi();
            }
            if (f instanceof QOM.Radians) {
                QOM.Radians e = (QOM.Radians)f;
                return Cypher.radians(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sin) {
                QOM.Sin e = (QOM.Sin)f;
                return Cypher.sin(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Tan) {
                QOM.Tan e = (QOM.Tan)f;
                return Cypher.tan(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.CharLength) {
                QOM.CharLength e = (QOM.CharLength)f;
                return Cypher.size(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Left) {
                QOM.Left e = (QOM.Left)f;
                return Cypher.left(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Lower) {
                QOM.Lower e = (QOM.Lower)f;
                return Cypher.toLower(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ltrim) {
                QOM.Ltrim e = (QOM.Ltrim)f;
                return Cypher.ltrim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Replace) {
                QOM.Replace e = (QOM.Replace)f;
                return Cypher.replace(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.Reverse) {
                QOM.Reverse e = (QOM.Reverse)f;
                return Cypher.reverse(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Right) {
                QOM.Right e = (QOM.Right)f;
                return Cypher.right(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Rtrim) {
                QOM.Rtrim e = (QOM.Rtrim)f;
                return Cypher.rtrim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Substring) {
                QOM.Substring e = (QOM.Substring)f;
                Expression length = this.expression((Field)e.$arg3());
                if (length != Cypher.literalNull()) {
                    return Cypher.substring(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), length);
                }
                return Cypher.substring(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), null);
            }
            if (f instanceof QOM.Trim) {
                QOM.Trim e = (QOM.Trim)f;
                if (e.$arg2() != null) {
                    throw ContextAwareStatementBuilder.unsupported(e);
                }
                return Cypher.trim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Upper) {
                QOM.Upper e = (QOM.Upper)f;
                return Cypher.toUpper(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Coalesce) {
                QOM.Coalesce e = (QOM.Coalesce)f;
                return Cypher.coalesce((Expression[])((QOM.UnmodifiableList)e.$arg1()).stream().map(this::expression).toArray(Expression[]::new));
            }
            if (f instanceof QOM.Nvl) {
                QOM.Nvl e = (QOM.Nvl)f;
                return Cypher.coalesce(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Nullif) {
                QOM.Nullif e = (QOM.Nullif)f;
                return Cypher.caseExpression().when(this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()))).then(Cypher.literalNull()).elseDefault(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Nvl2) {
                QOM.Nvl2 e = (QOM.Nvl2)f;
                return Cypher.caseExpression().when(this.expression((Field)e.$arg1()).isNotNull()).then(this.expression((Field)e.$arg2())).elseDefault(this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.CaseSimple) {
                QOM.CaseSimple e = (QOM.CaseSimple)f;
                Case c = Cypher.caseExpression(this.expression(e.$value()));
                for (QOM.Tuple2 tuple2 : e.$when()) {
                    c = c.when(this.expression((Field)tuple2.$1())).then(this.expression((Field)tuple2.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.CaseSearched) {
                QOM.CaseSearched e = (QOM.CaseSearched)f;
                Case c = Cypher.caseExpression();
                for (QOM.Tuple2 tuple2 : e.$when()) {
                    c = c.when(this.condition((Condition)tuple2.$1())).then(this.expression((Field)tuple2.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.Cast) {
                QOM.Cast e = (QOM.Cast)f;
                if (e.$dataType().isString()) {
                    return Cypher.toString(this.expression(e.$field()));
                }
                if (e.$dataType().isBoolean()) {
                    return Cypher.toBoolean(this.expression(e.$field()));
                }
                if (e.$dataType().isFloat()) {
                    return Cypher.toFloat(this.expression(e.$field()));
                }
                if (e.$dataType().isInteger()) {
                    return Cypher.toInteger(this.expression(e.$field()));
                }
                throw ContextAwareStatementBuilder.unsupported(f);
            }
            if (f instanceof True) {
                return Cypher.literalTrue();
            }
            if (f instanceof False) {
                return Cypher.literalFalse();
            }
            if (f instanceof QOM.Null || f == null || f instanceof Null) {
                return Cypher.literalNull();
            }
            if (f instanceof QOM.Function) {
                QOM.Function func = (QOM.Function)f;
                return this.buildFunction(func);
            }
            if (f instanceof QOM.Excluded && this.columnsAndValues.containsKey((excluded = (QOM.Excluded)f).$field().$name())) {
                return this.columnsAndValues.get(excluded.$field().$name());
            }
            if (f instanceof QOM.Count) {
                QOM.Count c = (QOM.Count)f;
                Field<?> field = c.$field();
                Expression exp = field instanceof Asterisk || "*".equals(field.toString()) ? Cypher.asterisk() : this.expression(field, true);
                return c.$distinct() ? Cypher.countDistinct(exp) : Cypher.count(exp);
            }
            if (f instanceof Asterisk) {
                return Cypher.asterisk();
            }
            if (f instanceof QOM.Min) {
                QOM.Min m = (QOM.Min)f;
                return Cypher.min(this.expression(m.$field()));
            }
            if (f instanceof QOM.Max) {
                QOM.Max m = (QOM.Max)f;
                return Cypher.max(this.expression(m.$field()));
            }
            if (f instanceof QOM.Sum) {
                QOM.Sum s = (QOM.Sum)f;
                return Cypher.sum(this.expression(s.$field()));
            }
            if (f instanceof QOM.Avg) {
                QOM.Avg s = (QOM.Avg)f;
                return Cypher.avg(this.expression(s.$field()));
            }
            if (f instanceof QOM.StddevSamp) {
                QOM.StddevSamp s = (QOM.StddevSamp)f;
                return Cypher.stDev(this.expression(s.$field()));
            }
            if (f instanceof QOM.StddevPop) {
                QOM.StddevPop s = (QOM.StddevPop)f;
                return Cypher.stDevP(this.expression(s.$field()));
            }
            if (f instanceof QOM.Position) {
                QOM.Position p = (QOM.Position)f;
                return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(FUNCTION_MAPPING.get("strpos")).withArgs(this.expression(p.$in()), this.expression((Field)p.$arg2()))).asFunction();
            }
            if (f instanceof QOM.ArrayGet && (Q1 = (g = (QOM.ArrayGet)f).$arg1()) instanceof TableField) {
                TableField tf = (TableField)Q1;
                return Cypher.valueAt(this.expression(tf), this.expression((Field)g.$arg2()));
            }
            if (f instanceof QOM.CurrentTimestamp) {
                return Cypher.localdatetime();
            }
            if (f instanceof QOM.Extract) {
                QOM.Extract extract = (QOM.Extract)f;
                return switch (extract.$datePart()) {
                    case DatePart.YEAR -> this.expression(extract.$field()).property("year");
                    case DatePart.MONTH -> this.expression(extract.$field()).property("month");
                    case DatePart.DAY -> this.expression(extract.$field()).property("day");
                    case DatePart.HOUR -> this.expression(extract.$field()).property("hour");
                    case DatePart.MINUTE -> this.expression(extract.$field()).property("minute");
                    case DatePart.SECOND -> this.expression(extract.$field()).property("SECOND");
                    case DatePart.MILLISECOND -> this.expression(extract.$field()).property("millisecond");
                    default -> throw new IllegalStateException("Unsupported value for date/time extraction: " + String.valueOf((Object)extract.$datePart()));
                };
            }
            if (f instanceof QOM.Concat) {
                QOM.Concat concat = (QOM.Concat)f;
                return this.concat((List)concat.$arg1());
            }
            throw ContextAwareStatementBuilder.unsupported(f);
        }

        private Expression concat(List<? extends Field<?>> args) {
            Field<?> first = args.get(0);
            if (args.size() == 1) {
                return this.expression(first);
            }
            return Cypher.concat(this.expression(first), this.concat(args.subList(1, args.size())));
        }

        private Expression buildFunction(QOM.Function<?> func) {
            Function<Field, Expression> asExpression = v -> this.expression((Field<?>)v, true);
            return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(FUNCTION_MAPPING.getOrDefault(func.getName().toLowerCase(Locale.ROOT), func.getName())).withArgs((Expression[])func.$args().stream().map(asExpression).toArray(Expression[]::new))).asFunction();
        }

        private <T> org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition(Condition c) {
            try {
                QOM.FieldCondition fc;
                Object result3;
                this.useAliasForVColumn.set(false);
                if (c instanceof QOM.And) {
                    QOM.And a = (QOM.And)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)a.$arg1()).and(this.condition((Condition)a.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Or) {
                    QOM.Or o = (QOM.Or)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).or(this.condition((Condition)o.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Xor) {
                    QOM.Xor o = (QOM.Xor)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).xor(this.condition((Condition)o.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Not) {
                    QOM.Not o = (QOM.Not)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).not();
                    return condition;
                }
                if (c instanceof QOM.Eq) {
                    QOM.Eq e = (QOM.Eq)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Gt) {
                    QOM.Gt e = (QOM.Gt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).gt(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Ge) {
                    QOM.Ge e = (QOM.Ge)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).gte(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Lt) {
                    QOM.Lt e = (QOM.Lt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).lt(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Le) {
                    QOM.Le e = (QOM.Le)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Between) {
                    QOM.Between e = (QOM.Between)c;
                    if (e.$symmetric()) {
                        QOM.Between t = e;
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition(t.$symmetric(false)).or(this.condition((Condition)((QOM.Between)t.$symmetric(false).$arg2((Field)t.$arg3())).$arg3((Field)t.$arg2())));
                        return condition;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg2()).lte(this.expression((Field)e.$arg1())).and(this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg3())));
                    return t;
                }
                if (c instanceof QOM.Ne) {
                    QOM.Ne e = (QOM.Ne)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).ne(this.expression((Field)e.$arg2()));
                    return t;
                }
                if (c instanceof QOM.IsNull) {
                    QOM.IsNull e = (QOM.IsNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).isNull();
                    return t;
                }
                if (c instanceof QOM.IsNotNull) {
                    QOM.IsNotNull e = (QOM.IsNotNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).isNotNull();
                    return t;
                }
                if (c instanceof QOM.RowEq) {
                    QOM.RowEq e = (QOM.RowEq)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result2 = null;
                    for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition r = this.expression(((Row)e.$arg1()).field(i)).eq(this.expression(((Row)e.$arg2()).field(i)));
                        result2 = result2 != null ? result2.and(r) : r;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition i = result2;
                    return i;
                }
                if (c instanceof QOM.RowNe) {
                    QOM.RowNe e = (QOM.RowNe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = null;
                    for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition r = this.expression(((Row)e.$arg1()).field(i)).ne(this.expression(((Row)e.$arg2()).field(i)));
                        result3 = result3 != null ? result3.and(r) : r;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition i = result3;
                    return i;
                }
                if (c instanceof QOM.RowGt) {
                    QOM.RowGt e = (QOM.RowGt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gt);
                    return result3;
                }
                if (c instanceof QOM.RowGe) {
                    QOM.RowGe e = (QOM.RowGe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gte);
                    return result3;
                }
                if (c instanceof QOM.RowLt) {
                    QOM.RowLt e = (QOM.RowLt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lt);
                    return result3;
                }
                if (c instanceof QOM.RowLe) {
                    QOM.RowLe e = (QOM.RowLe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lte);
                    return result3;
                }
                if (c instanceof QOM.RowIsNull) {
                    QOM.RowIsNull e = (QOM.RowIsNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNull()).reduce(org.neo4j.jdbc.internal.shaded.cypherdsl.Condition::and).orElseThrow();
                    return result3;
                }
                if (c instanceof QOM.RowIsNotNull) {
                    QOM.RowIsNotNull e = (QOM.RowIsNotNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNotNull()).reduce(org.neo4j.jdbc.internal.shaded.cypherdsl.Condition::and).orElseThrow();
                    return result3;
                }
                if (c instanceof QOM.Like) {
                    QOM.Like like = (QOM.Like)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result3 = this.like(like);
                    return result3;
                }
                if (c instanceof QOM.FieldCondition && (result3 = (fc = (QOM.FieldCondition)c).$field()) instanceof Param) {
                    Param param = (Param)result3;
                    result3 = (Boolean.TRUE.equals(param.getValue()) ? Cypher.literalTrue() : Cypher.literalFalse()).asCondition();
                    return result3;
                }
                if (c instanceof QOM.InList) {
                    Expression expression;
                    Expression expression2;
                    QOM.InList il = (QOM.InList)c;
                    List<Expression> searchList = il.$list().stream().map(this::expression).toList();
                    Expression expression3 = this.expression(il.$field());
                    if (searchList.size() == 1 && (expression2 = searchList.get(0)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression2;
                        expression = parameter;
                    } else {
                        expression = Cypher.listOf(searchList);
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = expression3.in(expression);
                    return condition;
                }
                throw ContextAwareStatementBuilder.unsupported(c);
            }
            finally {
                this.useAliasForVColumn.set(true);
            }
        }

        private org.neo4j.jdbc.internal.shaded.cypherdsl.Condition like(QOM.Like like) {
            Literal rhs;
            Param p;
            Expression lhs = this.expression((Field)like.$arg1());
            Object object = like.$arg2();
            if (object instanceof Param && (p = (Param)object).$inline() && (object = p.getValue()) instanceof String) {
                final String s = (String)object;
                boolean sw = s.startsWith("%");
                boolean ew = s.endsWith("%");
                int length = s.length();
                var cnt = new LongSupplier(){
                    Long value;
                    final /* synthetic */ ContextAwareStatementBuilder this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public long getAsLong() {
                        if (this.value == null) {
                            this.value = PERCENT_OR_UNDERSCORE.matcher(s).results().count();
                        }
                        return this.value;
                    }
                };
                if (sw && ew && length > 2 && cnt.getAsLong() == 2L) {
                    return lhs.contains(Cypher.literalOf(s.substring(1, length - 1)));
                }
                if (sw && length > 1 && cnt.getAsLong() == 1L) {
                    return lhs.endsWith(Cypher.literalOf(s.substring(1)));
                }
                if (ew && length > 1 && cnt.getAsLong() == 1L) {
                    return lhs.startsWith(Cypher.literalOf(s.substring(0, length - 1)));
                }
                rhs = Cypher.literalOf(s.replaceAll("%+", ".*").replace("_", "."));
            } else {
                rhs = this.expression((Field)like.$arg2());
            }
            return lhs.matches(rhs);
        }

        private org.neo4j.jdbc.internal.shaded.cypherdsl.Condition rowCondition(Row r1, Row r2, BiFunction<? super Expression, ? super Expression, ? extends org.neo4j.jdbc.internal.shaded.cypherdsl.Condition> comp, BiFunction<? super Expression, ? super Expression, ? extends org.neo4j.jdbc.internal.shaded.cypherdsl.Condition> last) {
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result = last.apply(this.expression(r1.field(r1.size() - 1)), this.expression(r2.field(r1.size() - 1)));
            for (int i = r1.size() - 2; i >= 0; --i) {
                Expression e1 = this.expression(r1.field(i));
                Expression e2 = this.expression(r2.field(i));
                result = comp.apply(e1, e2).or(e1.eq(e2).and(result));
            }
            return result;
        }

        private List<PatternElement> resolveTableOrJoin(Table<?> t) {
            RelationshipPattern relationship = this.resolvedRelationships.get(Cypher.name(t.getName()));
            if (relationship != null) {
                return List.of(relationship);
            }
            if (t instanceof QOM.JoinTable) {
                QOM.JoinTable joinTable = (QOM.JoinTable)t;
                return this.resolveJoin(joinTable);
            }
            if (t instanceof QOM.TableAlias) {
                PatternElement resolved;
                QOM.TableAlias ta = (QOM.TableAlias)t;
                List<PatternElement> patternElements = this.resolveTableOrJoin((Table<?>)ta.$aliased());
                PatternElement patternElement = resolved = patternElements.size() == 1 ? patternElements.get(0) : null;
                if ((resolved instanceof Node || resolved instanceof Relationship) && !ta.$alias().empty()) {
                    return List.of(this.nodeOrPattern((Table<?>)ta.$aliased(), ta.$alias().last()));
                }
                throw ContextAwareStatementBuilder.unsupported(ta);
            }
            return List.of(this.nodeOrPattern(t, t.getName()));
        }

        private PatternElement nodeOrPattern(Table<?> t, String name) {
            Matcher matcher;
            String primaryLabel = this.labelOrType(t);
            SymbolicName symbolicName = ContextAwareStatementBuilder.symbolicName(Objects.requireNonNull(name));
            RelationshipPattern relationship = this.resolvedRelationships.get(symbolicName);
            if (relationship != null) {
                return relationship;
            }
            boolean tableExists = false;
            if (this.databaseMetaData != null) {
                try (ResultSet resultSet = this.databaseMetaData.getTables(null, null, primaryLabel, new String[]{"TABLE", "RELATIONSHIP"});){
                    while (resultSet.next()) {
                        String type = resultSet.getString("TABLE_TYPE");
                        if ("TABLE".equals(type)) {
                            tableExists = true;
                            break;
                        }
                        if (!"RELATIONSHIP".equals(type)) continue;
                        String[] definition = resultSet.getString("REMARKS").split("\n");
                        relationship = ((Relationship)Cypher.node(definition[0], new String[0]).named(SqlToCypher.NODE_NAME_START).relationshipTo(Cypher.node(definition[2], new String[0]).named(SqlToCypher.NODE_NAME_END), definition[1])).named(symbolicName);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!tableExists && relationship == null && this.relationshipPattern != null && (matcher = this.relationshipPattern.matcher(primaryLabel)).matches()) {
                relationship = ((Relationship)Cypher.node(this.namedGroupOrIndex(matcher, SqlToCypher.NG_START, 1), new String[0]).named(SqlToCypher.NODE_NAME_START).relationshipTo(Cypher.node(this.namedGroupOrIndex(matcher, SqlToCypher.NG_END, 2), new String[0]).named(SqlToCypher.NODE_NAME_END), this.namedGroupOrIndex(matcher, SqlToCypher.NG_RELTYPE, 3))).named(symbolicName);
            }
            if (relationship != null) {
                this.resolvedRelationships.put(symbolicName, relationship);
                return relationship;
            }
            return Cypher.node(primaryLabel, new String[0]).named(symbolicName);
        }

        String namedGroupOrIndex(Matcher m, String name, int idx) {
            try {
                return m.group(name);
            }
            catch (IllegalArgumentException ex) {
                return m.group(idx);
            }
        }

        private List<PatternElement> resolveJoin(QOM.JoinTable<?, ? extends Table<?>> joinTable) {
            RelationshipPattern relationship;
            PatternElement lhs;
            if (joinTable instanceof QOM.NaturalFullJoin) {
                throw ContextAwareStatementBuilder.unsupported(joinTable);
            }
            JoinDetails join = JoinDetails.of(joinTable);
            String relType = null;
            SymbolicName relSymbolicName = null;
            Table<?> t1 = joinTable.$table1();
            if (t1 instanceof QOM.JoinTable) {
                QOM.JoinTable lhsJoin = (QOM.JoinTable)t1;
                lhs = this.resolveTableOrJoin(lhsJoin.$table1()).get(0);
                JoinDetails eqJoin2 = JoinDetails.of(lhsJoin);
                RelationshipPattern relationship2 = this.tryToIntegrateNodeAndVirtualTable(lhs, this.resolveTableOrJoin(lhsJoin.$table2()).get(0), eqJoin2.eq);
                if (relationship2 != null) {
                    lhs = relationship2;
                } else {
                    relType = this.labelOrType(lhsJoin.$table2());
                    Table<?> table = lhsJoin.$table2();
                    if (table instanceof QOM.TableAlias) {
                        QOM.TableAlias tableAlias = (QOM.TableAlias)table;
                        relSymbolicName = ContextAwareStatementBuilder.symbolicName(tableAlias.getName());
                    }
                }
            } else if (join.eq != null) {
                lhs = this.resolveTableOrJoin(t1).get(0);
                relType = this.type(t1, (Field)join.eq.$arg2());
            } else {
                if (join.join != null && join.join.$using().isEmpty()) {
                    throw ContextAwareStatementBuilder.unsupported(joinTable);
                }
                lhs = this.resolveTableOrJoin(t1).get(0);
                String string = relType = join.join != null ? this.type(t1, (Field)join.join.$using().get(0)) : null;
            }
            if (relSymbolicName == null && relType != null) {
                relSymbolicName = ContextAwareStatementBuilder.symbolicName(relType);
            }
            PatternElement rhs = this.resolveTableOrJoin(joinTable.$table2()).get(0);
            if (lhs instanceof ExposesRelationships) {
                ExposesRelationships from = (ExposesRelationships)((Object)lhs);
                if (rhs instanceof Node) {
                    QOM.TableAlias ta;
                    QOM.JoinTable previousJoinTable;
                    Node to = (Node)rhs;
                    relationship = this.tryToIntegrateNodeAndVirtualTable(lhs, rhs, join.eq);
                    if (relationship != null) {
                        return List.of(relationship);
                    }
                    ArrayList<PatternElement> resolved = new ArrayList<PatternElement>();
                    Table<?> leftMost = joinTable.$table1();
                    while (leftMost instanceof QOM.JoinTable) {
                        QOM.JoinTable tab = (QOM.JoinTable)leftMost;
                        leftMost = tab.$table1();
                    }
                    PatternElement hlp = this.resolveTableOrJoin(leftMost).get(0);
                    if (from instanceof Relationship) {
                        Relationship r = (Relationship)from;
                        if (hlp instanceof Node) {
                            Object object;
                            Node leftMostNode = (Node)hlp;
                            if (r.getLeft().getRequiredSymbolicName().equals(leftMostNode.getRequiredSymbolicName()) && (object = joinTable.$table1()) instanceof QOM.JoinTable && (object = this.nodeOrPattern((previousJoinTable = (QOM.JoinTable)object).$table2(), "ignored")) instanceof Relationship) {
                                Relationship targetRelationship = (Relationship)object;
                                resolved.add(lhs);
                                from = leftMostNode;
                                relType = targetRelationship.getDetails().getTypes().get(0);
                            }
                        }
                    }
                    Relationship.Direction direction = Relationship.Direction.LTR;
                    if (join.eq != null && (previousJoinTable = joinTable.$table2()) instanceof QOM.TableAlias && !(ta = (QOM.TableAlias)((Object)previousJoinTable)).$alias().empty() && Objects.equals(ta.$alias().last(), ((Field)join.eq.$arg2()).getQualifiedName().first())) {
                        direction = Relationship.Direction.RTL;
                    }
                    relationship = from.relationshipWith(to, direction, relType);
                    if (relSymbolicName != null) {
                        if (relationship instanceof Relationship) {
                            Relationship r = (Relationship)relationship;
                            relationship = r.named(relSymbolicName);
                        } else if (relationship instanceof RelationshipChain) {
                            RelationshipChain r = (RelationshipChain)relationship;
                            relationship = r.named(relSymbolicName);
                        }
                        this.resolvedRelationships.put(relSymbolicName, relationship);
                    }
                    resolved.add(relationship);
                    return resolved;
                }
            }
            if ((relationship = this.tryToIntegrateNodeAndVirtualTable(lhs, rhs, join.eq)) != null) {
                return List.of(relationship);
            }
            throw ContextAwareStatementBuilder.unsupported(joinTable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RelationshipPattern tryToIntegrateNodeAndVirtualTable(PatternElement lhs, PatternElement rhs, QOM.Eq<?> eq) {
            Node node = ContextAwareStatementBuilder.findNodeInJoin(lhs, rhs);
            Relationship rel = ContextAwareStatementBuilder.findRelInJoin(lhs, rhs);
            if (eq == null || node == null || rel == null) {
                return null;
            }
            Set<CachedColumn> relationshipColumns = this.getColumnsOf(ContextAwareStatementBuilder.toTableName(rel));
            if (ContextAwareStatementBuilder.joinedByElementId((Field)eq.$arg1(), (Field)eq.$arg2(), rel.getLeft()) || ContextAwareStatementBuilder.joinedByElementId((Field)eq.$arg2(), (Field)eq.$arg1(), rel.getLeft()) || ContextAwareStatementBuilder.joinedByScopeColumn((Field)eq.$arg1(), rel.getLeft(), relationshipColumns) || this.joinedOnArbitraryColumns(eq, node, rel.getLeft(), relationshipColumns)) {
                Relationship relationship = ((Relationship)node.relationshipTo(rel.getRight(), (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                this.resolvedRelationships.put(relationship.getRequiredSymbolicName(), relationship);
                return relationship;
            }
            if (ContextAwareStatementBuilder.joinedByElementId((Field)eq.$arg1(), (Field)eq.$arg2(), rel.getRight()) || ContextAwareStatementBuilder.joinedByElementId((Field)eq.$arg2(), (Field)eq.$arg1(), rel.getRight()) || ContextAwareStatementBuilder.joinedByScopeColumn((Field)eq.$arg2(), rel.getRight(), relationshipColumns) || this.joinedOnArbitraryColumns(eq, node, rel.getRight(), relationshipColumns)) {
                Relationship relationship = ((Relationship)rel.getLeft().relationshipTo(node, (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                this.resolvedRelationships.put(relationship.getRequiredSymbolicName(), relationship);
                return relationship;
            }
            if (ContextAwareStatementBuilder.fitsLeftOrRight(node, rel)) {
                try {
                    this.useAliasForVColumn.set(false);
                    Expression e1 = null;
                    Expression e2 = null;
                    PatternElement relationship = null;
                    if (ContextAwareStatementBuilder.isElementIdFor((Field)eq.$arg1(), rel.getLeft())) {
                        relationship = ((Relationship)node.relationshipTo(rel.getRight(), (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                        e1 = this.makeId(relationship.getLeft(), null);
                        e2 = this.makeId((PropertyContainer)((Object)relationship), null);
                    } else if (ContextAwareStatementBuilder.isElementIdFor((Field)eq.$arg1(), rel.getRight())) {
                        relationship = ((Relationship)rel.getLeft().relationshipTo(node, (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                        e1 = this.makeId(relationship.getRight(), null);
                        e2 = this.makeId((PropertyContainer)((Object)relationship), null);
                    }
                    if (relationship != null) {
                        relationship = (Relationship)relationship.where(Cypher.isEqualTo(e1, e2));
                        this.resolvedRelationships.put(relationship.getRequiredSymbolicName(), (RelationshipPattern)relationship);
                        PatternElement patternElement = relationship;
                        return patternElement;
                    }
                }
                finally {
                    this.useAliasForVColumn.set(true);
                }
            }
            return null;
        }

        private static boolean joinedByElementId(Field<?> src, Field<?> target, Node targetNode) {
            return ContextAwareStatementBuilder.isElementId(src) && ContextAwareStatementBuilder.isVirtualIdColumnForNode(targetNode, target.$name().last());
        }

        private static boolean joinedByScopeColumn(Field<?> src, Node targetNode, Set<CachedColumn> relationshipColumns) {
            return relationshipColumns.stream().anyMatch(c -> c.name().equals(src.getName()) && ContextAwareStatementBuilder.label(targetNode).equals(c.scopeTable));
        }

        private boolean joinedOnArbitraryColumns(QOM.Eq<?> eq, Node src, Node target, Set<CachedColumn> relationshipColumns) {
            String targetLabel;
            String srcLabel = ContextAwareStatementBuilder.label(src);
            boolean colLeftPresent = srcLabel.equals(targetLabel = ContextAwareStatementBuilder.label(target)) && this.getColumnsOf(srcLabel).stream().anyMatch(c -> c.name().equals(((Field)eq.$arg1()).getName()) || c.name().equals(((Field)eq.$arg2()).getName()));
            return colLeftPresent && relationshipColumns.stream().anyMatch(c -> c.name().equals(((Field)eq.$arg1()).getName()) || c.name().equals(((Field)eq.$arg2()).getName()));
        }

        private static String toTableName(PatternElement patternElement) {
            if (patternElement instanceof Relationship) {
                Relationship relationship = (Relationship)patternElement;
                return "%s_%s_%s".formatted(ContextAwareStatementBuilder.toTableName(relationship.getLeft()), String.join((CharSequence)"", relationship.getDetails().getTypes()), ContextAwareStatementBuilder.toTableName(relationship.getRight()));
            }
            if (patternElement instanceof Node) {
                Node node = (Node)patternElement;
                return node.getLabels().stream().map(NodeLabel::getValue).collect(Collectors.joining());
            }
            throw new IllegalArgumentException("Cannot derive a table name for " + String.valueOf(patternElement));
        }

        private static Node findNodeInJoin(PatternElement lhs, PatternElement rhs) {
            Node hlp;
            Node hlp2;
            Node node = lhs instanceof Node ? (hlp2 = (Node)lhs) : (rhs instanceof Node ? (hlp = (Node)rhs) : null);
            return node;
        }

        private static Relationship findRelInJoin(PatternElement lhs, PatternElement rhs) {
            Relationship hlp;
            Relationship hlp2;
            Relationship rel = lhs instanceof Relationship ? (hlp2 = (Relationship)lhs) : (rhs instanceof Relationship ? (hlp = (Relationship)rhs) : null);
            return rel;
        }

        static boolean isElementId(Field<?> field) {
            Matcher matcher = ELEMENT_ID_PATTERN.matcher(Objects.requireNonNull(field.$name().last()));
            if (!matcher.matches()) {
                return false;
            }
            String prefix = matcher.group("prefix");
            return prefix == null || prefix.isBlank() || "element".equalsIgnoreCase(prefix);
        }

        static boolean isElementIdFor(Field<?> field, Node node) {
            if (!ContextAwareStatementBuilder.isElementId(field)) {
                return false;
            }
            return node.getLabels().stream().anyMatch(l -> l.getValue().equals(field.$name().first()));
        }

        static String isFkId(Field<?> field) {
            Matcher matcher = ELEMENT_ID_PATTERN.matcher(Objects.requireNonNull(field.$name().last()));
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group("prefix");
            return prefix != null && !prefix.isBlank() ? prefix : null;
        }

        private static boolean fitsLeftOrRight(Node node, Relationship relationship) {
            boolean result = node.getLabels().stream().map(NodeLabel::getValue).anyMatch(l -> relationship.getLeft().getLabels().stream().map(NodeLabel::getValue).anyMatch(r -> r.equals(l)));
            if (result) {
                return result;
            }
            return node.getLabels().stream().map(NodeLabel::getValue).anyMatch(l -> relationship.getRight().getLabels().stream().map(NodeLabel::getValue).anyMatch(r -> r.equals(l)));
        }

        private static boolean isVirtualIdColumnForNode(Node node, String needle) {
            if (needle == null) {
                return false;
            }
            String string = "v$%s_id";
            return node.getLabels().stream().map(NodeLabel::getValue).map(arg_0 -> ContextAwareStatementBuilder.lambda$isVirtualIdColumnForNode$0("v$%s_id", arg_0)).anyMatch(needle::equalsIgnoreCase);
        }

        private static boolean isLabelOfNode(Node node, String needle) {
            if (needle == null) {
                return false;
            }
            return node.getLabels().stream().map(NodeLabel::getValue).anyMatch(needle::equals);
        }

        private static String label(Node node) {
            return node.getLabels().get(0).getValue();
        }

        private String labelOrType(Table<?> tableOrAlias) {
            QueryPart queryPart;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                queryPart = ta.$aliased();
            } else {
                queryPart = tableOrAlias;
            }
            Table<?> t = queryPart;
            String comment = t.getComment();
            if (!comment.isBlank()) {
                Map<String, String> localConfig = Arrays.stream(comment.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                return localConfig.getOrDefault("label", t.getName());
            }
            return this.config.getTableToLabelMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(t.getName())).findFirst().map(Map.Entry::getValue).orElseGet(t::getName);
        }

        private String type(Table<?> tableOrAlias, Field<?> field) {
            QueryPart queryPart;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                queryPart = ta.$aliased();
            } else {
                queryPart = tableOrAlias;
            }
            Table<?> t = queryPart;
            String key = t.getName() + "." + field.getName();
            return this.config.getJoinColumnsToTypeMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(Map.Entry::getValue).orElseGet(() -> ContextAwareStatementBuilder.relationshipTypeName(field));
        }

        private static /* synthetic */ String lambda$isVirtualIdColumnForNode$0(String rec$, Object xva$0) {
            return "v$%s_id".formatted(xva$0);
        }

        private /* synthetic */ void lambda$statement$3(ArrayList updates, PropertyContainer target, FieldOrRow c, FieldOrRowOrSelect v) {
            updates.add(target.property(((Field)c).getName()));
            updates.add(this.expression((Field)v));
        }
    }

    record CachedColumn(String name, boolean isGenerated, String scopeTable) {
        String unscopedName() {
            return this.scopeTable != null ? this.name.replace(this.scopeTable.toLowerCase(Locale.ROOT) + "_", "") : this.name;
        }
    }

    record CbvPointer(Table<?> table, String viewName, String alias) {
        static CbvPointer of(Table<?> table) {
            String name;
            String alias = name = table.$name().first();
            if (table instanceof QOM.TableAlias) {
                QOM.TableAlias tableAlias = (QOM.TableAlias)table;
                name = tableAlias.$aliased().$name().first();
            }
            return new CbvPointer(table, name, alias);
        }
    }

    record JoinDetails(QOM.QualifiedJoin<?, ?> join, QOM.Eq<?> eq) {
        static JoinDetails of(QOM.JoinTable<?, ?> joinTable) {
            QOM.Eq $eq;
            Condition condition;
            QOM.QualifiedJoin join = null;
            if (joinTable instanceof QOM.Join || joinTable instanceof QOM.LeftJoin) {
                join = (QOM.QualifiedJoin)joinTable;
            }
            QOM.Eq eq = join != null && (condition = join.$on()) instanceof QOM.Eq ? ($eq = (QOM.Eq)condition) : null;
            return new JoinDetails(join, eq);
        }
    }
}

