/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import org.neo4j.jdbc.values.AbstractNumberValue;
import org.neo4j.jdbc.values.LossyCoercion;
import org.neo4j.jdbc.values.Type;

public final class FloatValue
extends AbstractNumberValue<Double> {
    private final double val;

    FloatValue(double val) {
        this.val = val;
    }

    @Override
    public Type type() {
        return Type.FLOAT;
    }

    @Override
    public Double asNumber() {
        return this.val;
    }

    @Override
    public long asLong() {
        long longVal = (long)this.val;
        if (Double.compare(longVal, this.val) != 0) {
            throw new LossyCoercion(this.type().name(), "Java long");
        }
        return longVal;
    }

    @Override
    public int asInt() {
        int intVal = (int)this.val;
        if (Double.compare(intVal, this.val) != 0) {
            throw new LossyCoercion(this.type().name(), "Java int");
        }
        return intVal;
    }

    @Override
    public double asDouble() {
        return this.val;
    }

    @Override
    public float asFloat() {
        float floatVal = (float)this.val;
        if (Double.compare(floatVal, this.val) != 0) {
            throw new LossyCoercion(this.type().name(), "Java float");
        }
        return floatVal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatValue values = (FloatValue)o;
        return Double.compare(values.val, this.val) == 0;
    }

    @Override
    public int hashCode() {
        long temp = Double.doubleToLongBits(this.val);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public String toString() {
        return Double.toString(this.val);
    }
}

