/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.jdbc.BoltCursor;
import org.neo4j.jdbc.LocalCursor;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.values.Record;

interface Cursor {
    public static Cursor of(Neo4jTransaction transaction, Neo4jTransaction.RunResponse runResponse, int remainingRowAllowance, int fetchSize, Neo4jTransaction.PullResponse currentBatchResponse, Runnable onNextBatch) {
        List<Record> records = currentBatchResponse.records();
        Iterator<Record> currentBatch = records.iterator();
        return new BoltCursor(records.isEmpty() ? null : records.get(0), transaction, runResponse, remainingRowAllowance, fetchSize, currentBatchResponse, currentBatch, onNextBatch);
    }

    public static Cursor of(List<Record> records) {
        return new LocalCursor(records);
    }

    public boolean next() throws SQLException;

    public Record getCurrentRecord();

    public int getCurrentRowNum();

    public Record getSampleRecord();

    public boolean isLast();

    public void setFetchSize(int var1) throws SQLException;

    public int getFetchSize();

    default public void close() throws SQLException {
    }
}

