/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.jdbc.BookmarkManager;

final class DefaultBookmarkManagerImpl
implements BookmarkManager {
    private final Set<String> bookmarks = new HashSet<String>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    DefaultBookmarkManagerImpl() {
    }

    @Override
    public <T> Set<T> getBookmarks(Function<String, T> transformer) {
        try {
            this.read.lock();
            Set set = this.bookmarks.stream().map(transformer).collect(Collectors.toUnmodifiableSet());
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void updateBookmarks(Function<T, String> transformer, Collection<T> usedBookmarks, Collection<T> newBookmarks) {
        Objects.requireNonNull(transformer, "A function for deriving a String value from a bookmark is required");
        Objects.requireNonNull(newBookmarks, "New bookmarks might not be null");
        try {
            this.write.lock();
            if (usedBookmarks != null) {
                usedBookmarks.forEach(b -> this.bookmarks.remove(transformer.apply(b)));
            }
            newBookmarks.forEach(b -> this.bookmarks.add((String)transformer.apply(b)));
        }
        finally {
            this.write.unlock();
        }
    }
}

