/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.jdbc.AbstractCursor;
import org.neo4j.jdbc.values.Record;

final class LocalCursor
extends AbstractCursor {
    private final Iterator<Record> iterator;

    LocalCursor(List<Record> records) {
        super(records.isEmpty() ? null : records.get(0));
        this.iterator = records.iterator();
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.iterator.hasNext();
        if (hasNext) {
            this.currentRecord = this.iterator.next();
            ++this.currentRowNum;
        }
        return hasNext;
    }

    @Override
    public boolean isLast() {
        return this.iterator.hasNext();
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() {
        return Integer.MAX_VALUE;
    }
}

