/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class Neo4jConversions {
    private Neo4jConversions() {
    }

    static int toSqlTypeFromOldCypherType(String neo4jType) {
        return Neo4jConversions.toSqlType(Neo4jConversions.valueOfV5Name(neo4jType));
    }

    static String oldCypherTypesToNew(String neo4jType) {
        if (neo4jType == null) {
            return "ANY";
        }
        String value = neo4jType;
        if (value.startsWith("LIST<")) {
            value = "LIST";
        }
        return switch (value = value.replaceAll("( NOT)? NULL", "")) {
            case "Boolean" -> {
                String var4_4;
                yield var4_4 = "BOOLEAN";
            }
            case "Double" -> {
                String var4_5;
                yield var4_5 = "FLOAT";
            }
            case "Long" -> {
                String var4_6;
                yield var4_6 = "INTEGER";
            }
            case "String" -> {
                String var4_7;
                yield var4_7 = "STRING";
            }
            case "Point" -> {
                String var4_8;
                yield var4_8 = "POINT";
            }
            case "StringArray", "ByteArray", "DoubleArray", "LongArray" -> {
                String var4_9;
                yield var4_9 = "LIST";
            }
            case "Date" -> {
                String var4_10;
                yield var4_10 = "DATE";
            }
            case "Duration" -> {
                String var4_11;
                yield var4_11 = "DURATION";
            }
            case "DateTime" -> {
                String var4_12;
                yield var4_12 = "ZONED DATETIME";
            }
            case "Time" -> {
                String var4_13;
                yield var4_13 = "ZONED TIME";
            }
            case "LocalDateTime" -> {
                String var4_14;
                yield var4_14 = "LOCAL DATETIME";
            }
            case "LocalTime" -> {
                String var4_15;
                yield var4_15 = "LOCAL TIME";
            }
            case "Null" -> {
                String var4_16;
                yield var4_16 = "NULL";
            }
            case "Any" -> {
                String var4_17;
                yield var4_17 = "ANY";
            }
            default -> {
                try {
                    String var4_18;
                    yield var4_18 = Neo4jConversions.valueOfV5Name(neo4jType).name();
                }
                catch (IllegalArgumentException ex) {
                    String var4_19;
                    yield var4_19 = "OTHER";
                }
            }
        };
    }

    static int toSqlType(Type neo4jType) {
        return switch (neo4jType) {
            default -> throw new IncompatibleClassChangeError();
            case Type.ANY, Type.DURATION, Type.UNSUPPORTED -> 1111;
            case Type.BOOLEAN -> 16;
            case Type.BYTES -> 2004;
            case Type.STRING -> 12;
            case Type.NUMBER, Type.INTEGER -> -5;
            case Type.FLOAT -> 8;
            case Type.LIST, Type.VECTOR -> 2003;
            case Type.MAP, Type.POINT, Type.PATH, Type.RELATIONSHIP, Type.NODE -> 2002;
            case Type.DATE -> 91;
            case Type.TIME -> 92;
            case Type.DATE_TIME, Type.LOCAL_DATE_TIME, Type.LOCAL_TIME -> 93;
            case Type.NULL -> 0;
        };
    }

    static Type valueOfV5Name(String in) {
        if (in == null) {
            return Type.ANY;
        }
        String value = in.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase(Locale.ROOT);
        if (value.startsWith("LIST<")) {
            value = "LIST";
        }
        if (value.startsWith("VECTOR<") || value.endsWith("VECTOR")) {
            value = "VECTOR";
        }
        value = switch (value = value.replaceAll("( NOT)? NULL", "")) {
            case "LONG" -> Type.INTEGER.name();
            case "DOUBLE" -> Type.FLOAT.name();
            case "LOCAL TIME" -> Type.LOCAL_TIME.name();
            case "LOCAL DATETIME" -> Type.LOCAL_DATE_TIME.name();
            case "ZONED TIME" -> Type.TIME.name();
            case "ZONED DATETIME" -> Type.DATE_TIME.name();
            default -> value.endsWith("ARRAY") ? Type.LIST.name() : value;
        };
        return Type.valueOf(value);
    }

    private static ZoneOffset getZoneOffsetFrom(Calendar cal) {
        return Objects.requireNonNullElseGet(cal, Calendar::getInstance).getTimeZone().toZoneId().getRules().getOffset(cal.toInstant());
    }

    static Value asValue(Time time, Calendar calendar) {
        if (time == null) {
            return Values.NULL;
        }
        OffsetTime offsetTime = time.toLocalTime().atOffset(Neo4jConversions.getZoneOffsetFrom(calendar));
        return Values.value(offsetTime);
    }

    static Time asTime(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.TIME.isTypeOf(value)) {
            return Time.valueOf(value.asOffsetTime().toLocalTime());
        }
        if (Type.LOCAL_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asLocalTime());
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asZonedDateTime().toLocalTime());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Time.valueOf(value.asLocalDateTime().toLocalTime());
        }
        throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Time"));
    }

    static Time asTime(Value value, Calendar calendar) throws SQLException {
        OffsetTime offsetTime;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneOffset targetOffset = Neo4jConversions.getZoneOffsetFrom(calendar);
        if (Type.TIME.isTypeOf(value)) {
            offsetTime = value.asOffsetTime().withOffsetSameInstant(targetOffset);
        } else if (Type.LOCAL_TIME.isTypeOf(value)) {
            offsetTime = value.asLocalTime().atOffset(targetOffset);
        } else if (Type.DATE_TIME.isTypeOf(value)) {
            offsetTime = value.asZonedDateTime().toOffsetDateTime().withOffsetSameInstant(targetOffset).toOffsetTime();
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            offsetTime = value.asLocalDateTime().toLocalTime().atOffset(targetOffset);
        } else {
            throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Time"));
        }
        return Time.valueOf(offsetTime.toLocalTime());
    }

    static Value asValue(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return Values.NULL;
        }
        calendar = Objects.requireNonNullElseGet(calendar, Calendar::getInstance);
        ZonedDateTime zonedDateTime = timestamp.toLocalDateTime().atZone(calendar.getTimeZone().toZoneId());
        return Values.value(zonedDateTime);
    }

    static Timestamp asTimestamp(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Timestamp.valueOf(value.asZonedDateTime().toLocalDateTime());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Timestamp.valueOf(value.asLocalDateTime());
        }
        throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Timestamp"));
    }

    static Timestamp asTimestamp(Value value, Calendar calendar) throws SQLException {
        ZonedDateTime hlp;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneId zonedDateTime = calendar.getTimeZone().toZoneId();
        if (Type.DATE_TIME.isTypeOf(value)) {
            hlp = value.asZonedDateTime().withZoneSameInstant(zonedDateTime);
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            hlp = value.asLocalDateTime().atZone(zonedDateTime);
        } else {
            throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Timestamp"));
        }
        return Timestamp.valueOf(hlp.toLocalDateTime());
    }

    static Value asValue(Date date, Calendar calendar) {
        if (date == null) {
            return Values.NULL;
        }
        calendar = Objects.requireNonNullElseGet(calendar, Calendar::getInstance);
        ZonedDateTime zonedDateTime = date.toLocalDate().atStartOfDay(calendar.getTimeZone().toZoneId());
        return Values.value(zonedDateTime);
    }

    static Date asDate(Value value) throws SQLException {
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        if (Type.DATE.isTypeOf(value)) {
            return Date.valueOf(value.asLocalDate());
        }
        if (Type.DATE_TIME.isTypeOf(value)) {
            return Date.valueOf(value.asZonedDateTime().toLocalDate());
        }
        if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            return Date.valueOf(value.asLocalDateTime().toLocalDate());
        }
        throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Date"));
    }

    static Date asDate(Value value, Calendar calendar) throws SQLException {
        ZonedDateTime zonedDateTime;
        if (value == null || Type.NULL.isTypeOf(value)) {
            return null;
        }
        ZoneId targetZone = calendar.getTimeZone().toZoneId();
        if (Type.DATE.isTypeOf(value)) {
            zonedDateTime = value.asLocalDate().atStartOfDay(targetZone);
        } else if (Type.DATE_TIME.isTypeOf(value)) {
            zonedDateTime = value.asZonedDateTime().withZoneSameInstant(targetZone);
        } else if (Type.LOCAL_DATE_TIME.isTypeOf(value)) {
            zonedDateTime = value.asLocalDateTime().atZone(targetZone);
        } else {
            throw new Neo4jException(Neo4jException.GQLError.$22N37.withTemplatedMessage(value.toDisplayString(), "java.sql.Date"));
        }
        return Date.valueOf(zonedDateTime.toLocalDate());
    }

    static void assertTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (map != null && !map.isEmpty()) {
            String mapValue = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> "%s = %s".formatted(e.getKey(), e.getValue())).collect(Collectors.joining(", "));
            throw new Neo4jException(Neo4jException.GQLError.$22N11.withTemplatedMessage("non-empty type map %s".formatted(mapValue)));
        }
    }
}

