/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.jdbc.internal.shaded.bolt.SummaryCounters;
import org.neo4j.jdbc.values.Record;

interface Neo4jTransaction {
    public RunAndPullResponses runAndPull(String var1, Map<String, Object> var2, int var3, int var4) throws SQLException;

    public DiscardResponse runAndDiscard(String var1, Map<String, Object> var2, int var3, boolean var4) throws SQLException;

    public PullResponse pull(RunResponse var1, long var2) throws SQLException;

    public void commit() throws SQLException;

    public void rollback() throws SQLException;

    public void fail(SQLException var1) throws SQLException;

    public boolean isAutoCommit();

    default public boolean isRunnable() {
        return switch (this.getState().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> true;
            case 2, 3, 4, 5 -> false;
        };
    }

    default public boolean isOpen() {
        return switch (this.getState().ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1, 2 -> true;
            case 3, 4, 5 -> false;
        };
    }

    public State getState();

    public static enum State {
        NEW,
        READY,
        OPEN_FAILED,
        FAILED,
        COMMITTED,
        ROLLEDBACK;

    }

    public static interface DiscardResponse {
        public Optional<ResultSummary> resultSummary();
    }

    public static interface PullResponse {
        public List<Record> records();

        public Optional<ResultSummary> resultSummary();

        public boolean hasMore();
    }

    public static interface RunResponse {
        public long queryId();

        public List<String> keys();
    }

    public record ResultSummary(SummaryCounters counters) {
    }

    public record RunAndPullResponses(RunResponse runResponse, PullResponse pullResponse) {
    }
}

