/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import org.neo4j.jdbc.internal.shaded.bolt.SummaryCounters;

record SummaryCountersImpl(int nodesCreated, int nodesDeleted, int relationshipsCreated, int relationshipsDeleted, int propertiesSet, int labelsAdded, int labelsRemoved, int indexesAdded, int indexesRemoved, int constraintsAdded, int constraintsRemoved, int systemUpdates) implements SummaryCounters
{
    static final SummaryCountersImpl EMPTY_STATS = new SummaryCountersImpl(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

    @Override
    public int totalCount() {
        int sum = this.nodesCreated;
        sum += this.nodesDeleted;
        sum += this.relationshipsCreated;
        sum += this.relationshipsDeleted;
        sum += this.propertiesSet;
        sum += this.labelsAdded;
        sum += this.labelsRemoved;
        sum += this.indexesAdded;
        sum += this.indexesRemoved;
        sum += this.constraintsAdded;
        return sum += this.constraintsRemoved;
    }

    @Override
    public boolean containsUpdates() {
        return SummaryCountersImpl.isPositive(this.totalCount());
    }

    @Override
    public boolean containsSystemUpdates() {
        return SummaryCountersImpl.isPositive(this.systemUpdates);
    }

    private static boolean isPositive(int value) {
        return value > 0;
    }
}

