/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.time.DateTimeException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.jdbc.internal.bolt.NodeImpl;
import org.neo4j.jdbc.internal.bolt.PathImpl;
import org.neo4j.jdbc.internal.bolt.RelationshipImpl;
import org.neo4j.jdbc.internal.bolt.ValueImpl;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.values.Node;
import org.neo4j.jdbc.internal.shaded.bolt.values.Path;
import org.neo4j.jdbc.internal.shaded.bolt.values.Relationship;
import org.neo4j.jdbc.internal.shaded.bolt.values.Segment;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.values.BooleanValue;
import org.neo4j.jdbc.values.BytesValue;
import org.neo4j.jdbc.values.DateTimeValue;
import org.neo4j.jdbc.values.DateValue;
import org.neo4j.jdbc.values.DurationValue;
import org.neo4j.jdbc.values.FloatValue;
import org.neo4j.jdbc.values.IntegerValue;
import org.neo4j.jdbc.values.ListValue;
import org.neo4j.jdbc.values.LocalDateTimeValue;
import org.neo4j.jdbc.values.LocalTimeValue;
import org.neo4j.jdbc.values.MapValue;
import org.neo4j.jdbc.values.NodeValue;
import org.neo4j.jdbc.values.NullValue;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.PathValue;
import org.neo4j.jdbc.values.PointValue;
import org.neo4j.jdbc.values.RelationshipValue;
import org.neo4j.jdbc.values.StringValue;
import org.neo4j.jdbc.values.TimeValue;
import org.neo4j.jdbc.values.UnsupportedDateTimeValue;
import org.neo4j.jdbc.values.UnsupportedType;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;
import org.neo4j.jdbc.values.Vector;
import org.neo4j.jdbc.values.VectorValue;

enum ValueFactoryImpl implements ValueFactory
{
    INSTANCE;

    private static final Map<Class<? extends Value>, Type> TYPE_MAP;

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value value(Object value) {
        if (value instanceof ValueImpl) {
            ValueImpl boltValue = (ValueImpl)value;
            return boltValue;
        }
        return ValueFactoryImpl.asBoltValue(Values.value(value));
    }

    @Override
    public Node node(long id, String elementId, Collection<String> labels, Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> properties) {
        return new NodeImpl(id, elementId, labels, ValueFactoryImpl.toDriverMap(properties));
    }

    @Override
    public Relationship relationship(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> properties) {
        return new RelationshipImpl(id, elementId, startElementId, endElementId, type, ValueFactoryImpl.toDriverMap(properties));
    }

    @Override
    public Segment segment(Node start, Relationship relationship, Node end) {
        return new SelfContainedSegment((NodeImpl)start, (RelationshipImpl)relationship, (NodeImpl)end);
    }

    @Override
    public Path path(List<Segment> segments, List<Node> nodes, List<Relationship> relationships) {
        List<Path.Segment> segments0 = segments.stream().map(segment -> (Path.Segment)((Object)segment)).toList();
        List<org.neo4j.jdbc.values.Node> nodes0 = nodes.stream().map(node -> (org.neo4j.jdbc.values.Node)((Object)node)).toList();
        List<org.neo4j.jdbc.values.Relationship> relationships0 = relationships.stream().map(relationship -> (org.neo4j.jdbc.values.Relationship)((Object)relationship)).toList();
        return new PathImpl(segments0, nodes0, relationships0);
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return ValueFactoryImpl.asBoltValue(Values.isoDuration(months, days, seconds, nanoseconds));
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value point(int srid, double x, double y) {
        return ValueFactoryImpl.asBoltValue(Values.point(srid, x, y));
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value point(int srid, double x, double y, double z) {
        return ValueFactoryImpl.asBoltValue(Values.point(srid, x, y, z));
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value value(org.neo4j.jdbc.internal.shaded.bolt.values.Vector vector) {
        return this.vector(vector.elementType(), vector.elements());
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value vector(Class<?> elementType, Object elements) {
        Vector vector;
        if (elementType == Byte.TYPE) {
            vector = Vector.of((byte[])elements);
        } else if (elementType == Short.TYPE) {
            vector = Vector.of((short[])elements);
        } else if (elementType == Integer.TYPE) {
            vector = Vector.of((int[])elements);
        } else if (elementType == Long.TYPE) {
            vector = Vector.of((long[])elements);
        } else if (elementType == Float.TYPE) {
            vector = Vector.of((float[])elements);
        } else if (elementType == Double.TYPE) {
            vector = Vector.of((double[])elements);
        } else {
            throw new IllegalArgumentException("Element type %s is not a supported element type for vectors".formatted(elementType.getName()));
        }
        return ValueFactoryImpl.asBoltValue(vector.asValue());
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value unsupportedType(String name, BoltProtocolVersion minProtocolVersion, Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> extra) {
        org.neo4j.jdbc.internal.shaded.bolt.values.Value message = extra.get("message");
        String messageString = message != null && message.boltValueType().equals((Object)Type.STRING) ? message.asString() : null;
        return new ValueImpl(new UnsupportedType(name, minProtocolVersion.toString(), messageString).asValue(), Type.UNSUPPORTED);
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value unsupportedDateTimeValue(DateTimeException e) {
        return ValueFactoryImpl.asBoltValue(new UnsupportedDateTimeValue(e));
    }

    private static Map<String, Value> toDriverMap(Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> map) {
        HashMap<String, Value> result = new HashMap<String, Value>(map.size());
        for (Map.Entry<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> entry : map.entrySet()) {
            Value boltValue = Values.value(entry.getValue());
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }

    static org.neo4j.jdbc.internal.shaded.bolt.values.Value asBoltValue(Value value) {
        Type type = TYPE_MAP.get(value.getClass());
        if (type == null && value instanceof BooleanValue) {
            type = Type.BOOLEAN;
        }
        return new ValueImpl(value, type);
    }

    static {
        HashMap<Class, Type> hlp = new HashMap<Class, Type>();
        hlp.put(NullValue.class, Type.NULL);
        hlp.put(DateValue.class, Type.DATE);
        hlp.put(BooleanValue.class, Type.BOOLEAN);
        hlp.put(LocalDateTimeValue.class, Type.LOCAL_DATE_TIME);
        hlp.put(StringValue.class, Type.STRING);
        hlp.put(TimeValue.class, Type.TIME);
        hlp.put(DurationValue.class, Type.DURATION);
        hlp.put(RelationshipValue.class, Type.RELATIONSHIP);
        hlp.put(UnsupportedDateTimeValue.class, Type.DATE_TIME);
        hlp.put(LocalTimeValue.class, Type.LOCAL_TIME);
        hlp.put(FloatValue.class, Type.FLOAT);
        hlp.put(MapValue.class, Type.MAP);
        hlp.put(DateTimeValue.class, Type.DATE_TIME);
        hlp.put(IntegerValue.class, Type.INTEGER);
        hlp.put(PointValue.class, Type.POINT);
        hlp.put(NodeValue.class, Type.NODE);
        hlp.put(PathValue.class, Type.PATH);
        hlp.put(ListValue.class, Type.LIST);
        hlp.put(BytesValue.class, Type.BYTES);
        hlp.put(VectorValue.class, Type.VECTOR);
        TYPE_MAP = Map.copyOf(hlp);
    }

    record SelfContainedSegment(org.neo4j.jdbc.values.Node start, org.neo4j.jdbc.values.Relationship relationship, org.neo4j.jdbc.values.Node end) implements Path.Segment,
    Segment
    {
        @Override
        public int hashCode() {
            return Objects.hash(this.start, this.relationship, this.end);
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SelfContainedSegment that = (SelfContainedSegment)other;
            return this.start.equals(that.start) && this.end.equals(that.end) && this.relationship.equals(that.relationship);
        }

        @Override
        public String toString() {
            return String.format("(%s)-[%s:%s]->(%s)", this.start.id(), this.relationship.id(), this.relationship.type(), this.end.id());
        }
    }
}

