/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.neo4j.jdbc.internal.bolt.ValueFactoryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.values.AsValue;
import org.neo4j.jdbc.values.IsoDuration;
import org.neo4j.jdbc.values.Point;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Vector;

final class ValueImpl
implements org.neo4j.jdbc.internal.shaded.bolt.values.Value,
AsValue {
    private static final AtomicReference<Function<Vector, Object>> ARRAY_VECTOR_ACCESSOR = new AtomicReference();
    private final Value value;
    private final Type type;

    ValueImpl(Value value, Type type) {
        this.value = Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public Type boltValueType() {
        return this.type;
    }

    @Override
    public boolean asBoolean() {
        return this.value.asBoolean();
    }

    @Override
    public byte[] asByteArray() {
        return this.value.asByteArray();
    }

    @Override
    public String asString() {
        return this.value.asString();
    }

    @Override
    public long asLong() {
        return this.value.asLong();
    }

    @Override
    public double asDouble() {
        return this.value.asDouble();
    }

    @Override
    public LocalDate asLocalDate() {
        return this.value.asLocalDate();
    }

    @Override
    public OffsetTime asOffsetTime() {
        return this.value.asOffsetTime();
    }

    @Override
    public LocalTime asLocalTime() {
        return this.value.asLocalTime();
    }

    @Override
    public LocalDateTime asLocalDateTime() {
        return this.value.asLocalDateTime();
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        return this.value.asZonedDateTime();
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.IsoDuration asBoltIsoDuration() {
        IsoDuration jdbcDuration = this.value.asIsoDuration();
        return new BoltIsoDurationImpl(jdbcDuration.months(), jdbcDuration.days(), jdbcDuration.seconds(), jdbcDuration.nanoseconds());
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Point asBoltPoint() {
        Point jdbcPoint = this.value.asPoint();
        return new BoltPointImpl(jdbcPoint.srid(), jdbcPoint.x(), jdbcPoint.y(), jdbcPoint.z());
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public Iterable<String> keys() {
        return this.value.keys();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Value getBoltValue(String key) {
        return ValueFactoryImpl.asBoltValue(this.value.get(key));
    }

    @Override
    public Iterable<org.neo4j.jdbc.internal.shaded.bolt.values.Value> boltValues() {
        return () -> new Iterator<org.neo4j.jdbc.internal.shaded.bolt.values.Value>(){
            private final Iterator<Value> iterator;
            {
                this.iterator = ValueImpl.this.value.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public org.neo4j.jdbc.internal.shaded.bolt.values.Value next() {
                return ValueFactoryImpl.asBoltValue(this.iterator.next());
            }
        };
    }

    @Override
    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    @Override
    public Map<String, org.neo4j.jdbc.internal.shaded.bolt.values.Value> asBoltMap() {
        return this.value.asMap(ValueFactoryImpl::asBoltValue);
    }

    @Override
    public org.neo4j.jdbc.internal.shaded.bolt.values.Vector asBoltVector() {
        Vector jdbcVector = this.value.asVector();
        Function<Vector, Object> accessor = ARRAY_VECTOR_ACCESSOR.updateAndGet(old -> {
            if (old != null) {
                return old;
            }
            try {
                Class<?> targetClass = Class.forName("org.neo4j.jdbc.values.ArrayBasedVectors");
                VarHandle vh = MethodHandles.privateLookupIn(targetClass, MethodHandles.lookup()).findStaticVarHandle(targetClass, "ELEMENT_ACCESSOR", Function.class);
                Function result = vh.get();
                return result;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        });
        return new BoltVectorImpl(jdbcVector.elementType().getJavaType(), accessor.apply(jdbcVector));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueImpl boltValue = (ValueImpl)o;
        return Objects.equals(this.value, boltValue.value) && this.type == boltValue.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Value asValue() {
        return this.value;
    }

    record BoltIsoDurationImpl(long months, long days, long seconds, int nanoseconds) implements org.neo4j.jdbc.internal.shaded.bolt.values.IsoDuration
    {
    }

    record BoltPointImpl(int srid, double x, double y, double z) implements org.neo4j.jdbc.internal.shaded.bolt.values.Point
    {
    }

    record BoltVectorImpl(Class<?> elementType, Object elements) implements org.neo4j.jdbc.internal.shaded.bolt.values.Vector
    {
    }
}

