/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound;

import java.util.concurrent.TimeUnit;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltConnectionInitialisationTimeoutException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltServiceUnavailableException;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.timeout.ReadTimeoutHandler;

public class ConnectTimeoutHandler
extends ReadTimeoutHandler {
    private final long overallTimeoutLimit;
    private boolean triggered;

    public ConnectTimeoutHandler(long timeoutMillis, long overallTimeoutLimit) {
        super(timeoutMillis, TimeUnit.MILLISECONDS);
        this.overallTimeoutLimit = overallTimeoutLimit;
    }

    @Override
    protected void readTimedOut(ChannelHandlerContext ctx) {
        if (!this.triggered) {
            this.triggered = true;
            ctx.fireExceptionCaught(this.unableToConnectError());
        }
    }

    private BoltServiceUnavailableException unableToConnectError() {
        return new BoltConnectionInitialisationTimeoutException("Unable to initialise connection in " + this.overallTimeoutLimit + "ms");
    }
}

