/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.util.MetadataExtractor;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;

public class HelloV51ResponseHandler
implements ResponseHandler {
    private static final String CONNECTION_ID_METADATA_KEY = "connection_id";
    public static final String CONFIGURATION_HINTS_KEY = "hints";
    public static final String CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY = "connection.recv_timeout_seconds";
    public static final String TELEMETRY_ENABLED_KEY = "telemetry.enabled";
    public static final String SSR_ENABLED_KEY = "ssr.enabled";
    private final Channel channel;
    private final CompletableFuture<String> helloFuture;

    public HelloV51ResponseHandler(Channel channel, CompletableFuture<String> helloFuture) {
        this.channel = channel;
        this.helloFuture = helloFuture;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            String serverAgent = MetadataExtractor.extractServer(metadata).asString();
            ChannelAttributes.setServerAgent(this.channel, serverAgent);
            String connectionId = HelloV51ResponseHandler.extractConnectionId(metadata);
            ChannelAttributes.setConnectionId(this.channel, connectionId);
            this.processConfigurationHints(metadata);
            this.helloFuture.complete(serverAgent);
        }
        catch (Throwable error) {
            this.onFailure(error);
            throw error;
        }
    }

    @Override
    public void onFailure(Throwable error) {
        ChannelAttributes.setClosing(this.channel);
        this.channel.close().addListener(future -> this.helloFuture.completeExceptionally(error));
    }

    @Override
    public void onRecord(List<Value> fields) {
        throw new UnsupportedOperationException();
    }

    private void processConfigurationHints(Map<String, Value> metadata) {
        Value configurationHints = metadata.get(CONFIGURATION_HINTS_KEY);
        if (configurationHints != null) {
            HelloV51ResponseHandler.getFromSupplierOrEmptyOnException(() -> configurationHints.getBoltValue(CONNECTION_RECEIVE_TIMEOUT_SECONDS_KEY).asLong()).ifPresent(timeout -> ChannelAttributes.setConnectionReadTimeout(this.channel, timeout));
            HelloV51ResponseHandler.getFromSupplierOrEmptyOnException(() -> {
                Value value = configurationHints.getBoltValue(TELEMETRY_ENABLED_KEY);
                return !value.isNull() && value.asBoolean();
            }).ifPresent(telemetryEnabled -> ChannelAttributes.setTelemetryEnabled(this.channel, telemetryEnabled));
            HelloV51ResponseHandler.getFromSupplierOrEmptyOnException(() -> {
                Value value = configurationHints.getBoltValue(SSR_ENABLED_KEY);
                return !value.isNull() && value.asBoolean();
            }).ifPresent(telemetryEnabled -> ChannelAttributes.setSsrEnabled(this.channel, telemetryEnabled));
        }
    }

    private static String extractConnectionId(Map<String, Value> metadata) {
        Value value = metadata.get(CONNECTION_ID_METADATA_KEY);
        if (value == null || value.isNull()) {
            throw new IllegalStateException("Unable to extract connection_id from a response to HELLO message. Received metadata: " + String.valueOf(metadata));
        }
        return value.asString();
    }

    private static <T> Optional<T> getFromSupplierOrEmptyOnException(Supplier<T> supplier) {
        try {
            return Optional.of(supplier.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

