/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api;

import java.time.Clock;
import java.util.Map;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProviderFactory;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ObservationProvider;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.QueryApiBoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public final class QueryApiBoltConnectionProviderFactory
implements BoltConnectionProviderFactory {
    private static final Set<String> SUPPORTED_SCHEMES = Set.of("http", "https");

    @Override
    public boolean supports(String scheme) {
        return SUPPORTED_SCHEMES.contains(scheme);
    }

    @Override
    public BoltConnectionProvider create(LoggingProvider loggingProvider, ValueFactory valueFactory, ObservationProvider observationProvider, Map<String, ?> additionalConfig) {
        return new QueryApiBoltConnectionProvider(loggingProvider, valueFactory, this.getClock(additionalConfig), observationProvider);
    }

    private Clock getClock(Map<String, ?> additionalConfig) {
        Object value = additionalConfig.get("clock");
        if (value instanceof Clock) {
            Clock clock = (Clock)value;
            return clock;
        }
        return Clock.systemUTC();
    }
}

