/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogonMessage;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ImmutableObservation;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.LogonSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;

final class LogonMessageHandler
implements MessageHandler<Void> {
    private final ResponseHandler handler;
    private final LogonMessage message;
    private final Consumer<AuthToken> authTokenHandler;

    LogonMessageHandler(ResponseHandler handler, LogonMessage message, Consumer<AuthToken> authTokenHandler) {
        this.handler = Objects.requireNonNull(handler);
        this.message = Objects.requireNonNull(message);
        this.authTokenHandler = Objects.requireNonNull(authTokenHandler);
    }

    @Override
    public CompletionStage<Void> exchange(ImmutableObservation parentObservation) {
        return CompletableFuture.completedStage(null).thenApply(ignored -> {
            this.authTokenHandler.accept(this.message.authToken());
            this.handler.onLogonSummary(LogonSummaryImpl.INSTANCE);
            return null;
        });
    }
}

