/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expressions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NestedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.EnterResult;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Comparison
implements Condition {
    private final Expression left;
    private final Operator comparator;
    private final Expression right;

    private Comparison(Expression left, Operator operator, Expression right) {
        this.left = Comparison.nestedIfCondition(left);
        this.comparator = operator;
        this.right = Comparison.nestedIfCondition(right);
    }

    static Comparison create(Operator operator, Expression expression) {
        Assertions.isTrue(operator.isUnary(), "Operator must be unary.");
        Assertions.notNull(expression, "Expression must not be null.");
        return switch (operator.getType()) {
            case Operator.Type.PREFIX -> new Comparison(null, operator, expression);
            case Operator.Type.POSTFIX -> new Comparison(expression, operator, null);
            default -> throw new IllegalArgumentException("Invalid operator type " + String.valueOf((Object)operator.getType()));
        };
    }

    static Comparison create(Expression lhs, Operator operator, Expression rhs) {
        Assertions.notNull(lhs, "Left expression must not be null.");
        Assertions.notNull(operator, "Operator must not be empty.");
        Assertions.notNull(rhs, "Right expression must not be null.");
        return new Comparison(lhs, operator, rhs);
    }

    private static Expression nestedIfCondition(Expression expression) {
        return expression instanceof Condition ? new NestedExpression(expression) : expression;
    }

    @Override
    public void accept(Visitor visitor) {
        EnterResult result = visitor.enterWithResult(this);
        if (result == EnterResult.CONTINUE) {
            if (this.left != null) {
                Expressions.nameOrExpression(this.left).accept(visitor);
            }
            this.comparator.accept(visitor);
            if (this.right != null) {
                Expressions.nameOrExpression(this.right).accept(visitor);
            }
        }
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL, since="2024.6.1")
    public Expression getLeft() {
        return this.left;
    }

    @API(status=API.Status.INTERNAL, since="2024.6.1")
    public Operator getComparator() {
        return this.comparator;
    }

    @API(status=API.Status.INTERNAL, since="2024.6.1")
    public Expression getRight() {
        return this.right;
    }

    @Override
    public Condition not() {
        if (this.comparator == Operator.IS_NULL) {
            return new Comparison(this.left, Operator.IS_NOT_NULL, this.right);
        }
        if (this.comparator == Operator.IS_NOT_NULL) {
            return new Comparison(this.left, Operator.IS_NULL, this.right);
        }
        return Condition.super.not();
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

