/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.TimeZone;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BuiltInFunctions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NamedPath;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NumberLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Reduction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

final class Functions {
    private Functions() {
    }

    @Deprecated(since="2023.3.0")
    static FunctionInvocation id(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, node.getRequiredSymbolicName());
    }

    @Deprecated(since="2023.3.0")
    static FunctionInvocation id(Relationship relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ID, relationship.getRequiredSymbolicName());
    }

    @Neo4jVersion(minimum="5.0.0")
    static FunctionInvocation elementId(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ELEMENT_ID, node.getRequiredSymbolicName());
    }

    @Neo4jVersion(minimum="5.0.0")
    static FunctionInvocation elementId(Relationship relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.ELEMENT_ID, relationship.getRequiredSymbolicName());
    }

    static FunctionInvocation keys(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return Functions.keys(node.getRequiredSymbolicName());
    }

    static FunctionInvocation keys(Relationship relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return Functions.keys(relationship.getRequiredSymbolicName());
    }

    static FunctionInvocation keys(Expression expression) {
        Expression expression2;
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        if (expression instanceof Named) {
            Named named = (Named)((Object)expression);
            expression2 = named.getRequiredSymbolicName();
        } else {
            expression2 = expression;
        }
        Expression param = expression2;
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.KEYS, param);
    }

    static FunctionInvocation labels(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return Functions.labels(node.getRequiredSymbolicName());
    }

    static FunctionInvocation labels(SymbolicName node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.LABELS, node);
    }

    static FunctionInvocation type(Relationship relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return Functions.type(relationship.getRequiredSymbolicName());
    }

    static FunctionInvocation type(SymbolicName relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TYPE, relationship);
    }

    static FunctionInvocation count(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    static FunctionInvocation count(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COUNT, expression);
    }

    static FunctionInvocation countDistinct(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, node.getRequiredSymbolicName());
    }

    static FunctionInvocation countDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COUNT, expression);
    }

    static FunctionInvocation properties(Node node) {
        Assertions.notNull(node, Cypher.MESSAGES.getString("assertions.node-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, node.getRequiredSymbolicName());
    }

    static FunctionInvocation properties(Relationship relationship) {
        Assertions.notNull(relationship, Cypher.MESSAGES.getString("assertions.relationship-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, relationship.getRequiredSymbolicName());
    }

    static FunctionInvocation properties(MapExpression map) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.PROPERTIES, map);
    }

    static FunctionInvocation coalesce(Expression ... expressions) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.COALESCE, expressions);
    }

    static FunctionInvocation left(Expression expression, Expression length) {
        if (expression != null && length == null) {
            throw new IllegalArgumentException("length might not be null when the expression is not null");
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.LEFT, Functions.expressionOrNullLit(expression), Functions.expressionOrNullLit(length));
    }

    static FunctionInvocation ltrim(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.LTRIM, Functions.expressionOrNullLit(expression));
    }

    static FunctionInvocation replace(Expression original, Expression search, Expression replace) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.REPLACE, Functions.expressionOrNullLit(original), Functions.expressionOrNullLit(search), Functions.expressionOrNullLit(replace));
    }

    static FunctionInvocation reverse(Expression original) {
        Assertions.notNull(original, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.REVERSE, Functions.expressionOrNullLit(original));
    }

    static FunctionInvocation right(Expression expression, Expression length) {
        if (expression != null && length == null) {
            throw new IllegalArgumentException("length might not be null when the expression is not null");
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.RIGHT, Functions.expressionOrNullLit(expression), Functions.expressionOrNullLit(length));
    }

    static FunctionInvocation rtrim(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.RTRIM, Functions.expressionOrNullLit(expression));
    }

    static FunctionInvocation substring(Expression original, Expression start, Expression length) {
        Assertions.notNull(start, "start is required");
        if (length != null) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.SUBSTRING, Functions.expressionOrNullLit(original), start, length);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.SUBSTRING, Functions.expressionOrNullLit(original), start);
    }

    private static Expression expressionOrNullLit(Expression expression) {
        return expression != null ? expression : Cypher.literalNull();
    }

    static FunctionInvocation toLower(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TO_LOWER, Functions.expressionOrNullLit(expression));
    }

    static FunctionInvocation toUpper(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TO_UPPER, Functions.expressionOrNullLit(expression));
    }

    static FunctionInvocation trim(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TRIM, expression);
    }

    static FunctionInvocation split(Expression expression, Expression delimiter) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        Assertions.notNull(delimiter, "The delimiter is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.SPLIT, expression, delimiter);
    }

    static FunctionInvocation split(Expression expression, String delimiter) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        Assertions.notNull(delimiter, "The delimiter is required.");
        return Functions.split(expression, Cypher.literalOf(delimiter));
    }

    static FunctionInvocation size(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, expression);
    }

    static FunctionInvocation size(RelationshipPattern pattern) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SIZE, pattern);
    }

    static FunctionInvocation exists(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, expression);
    }

    static FunctionInvocation distance(Expression point1, Expression point2) {
        Assertions.notNull(point1, "The distance function requires two points.");
        Assertions.notNull(point2, "The distance function requires two points.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.DISTANCE, point1, point2);
    }

    static FunctionInvocation point(MapExpression parameterMap) {
        return Functions.point((Expression)parameterMap);
    }

    static FunctionInvocation point(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, expression);
    }

    static FunctionInvocation point(Parameter<?> parameter) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Spatials.POINT, parameter);
    }

    static FunctionInvocation cartesian(double x, double y) {
        return Functions.point(Cypher.mapOf("x", Cypher.literalOf(x), "y", Cypher.literalOf(y)));
    }

    static FunctionInvocation coordinate(double longitude, double latitude) {
        return Functions.point(Cypher.mapOf("longitude", Cypher.literalOf(longitude), "latitude", Cypher.literalOf(latitude)));
    }

    static FunctionInvocation withinBBox(Expression point, Expression lowerLeft, Expression upperRight) {
        return FunctionInvocation.create(() -> "point.withinBBox", point, lowerLeft, upperRight);
    }

    static FunctionInvocation avg(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.AVG, expression);
    }

    static FunctionInvocation avgDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.AVG, expression);
    }

    static FunctionInvocation collect(Named variable) {
        Assertions.notNull(variable, Cypher.MESSAGES.getString("assertions.variable-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    static FunctionInvocation collectDistinct(Named variable) {
        Assertions.notNull(variable, Cypher.MESSAGES.getString("assertions.variable-required"));
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, variable.getRequiredSymbolicName());
    }

    static FunctionInvocation collect(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    static FunctionInvocation collectDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.COLLECT, expression);
    }

    static FunctionInvocation max(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MAX, expression);
    }

    static FunctionInvocation maxDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MAX, expression);
    }

    static FunctionInvocation min(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.MIN, expression);
    }

    static FunctionInvocation minDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.MIN, expression);
    }

    private static void assertPercentileArguments(BuiltInFunctions.Aggregates builtIn, Expression expression, Number percentile) {
        Assertions.notNull(expression, "The numeric expression for " + builtIn.getImplementationName() + " is required.");
        Assertions.notNull(percentile, "The percentile for " + builtIn.getImplementationName() + " is required.");
        double p = percentile.doubleValue();
        Assertions.isTrue(p >= 0.0 && p <= 1.0, "The percentile for " + builtIn.getImplementationName() + " must be between 0.0 and 1.0.");
    }

    static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    static FunctionInvocation percentileContDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_CONT, expression, new NumberLiteral(percentile));
    }

    static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    static FunctionInvocation percentileDiscDistinct(Expression expression, Number percentile) {
        Functions.assertPercentileArguments(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, percentile);
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.PERCENTILE_DISC, expression, new NumberLiteral(percentile));
    }

    static FunctionInvocation stDev(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    static FunctionInvocation stDevDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV, expression);
    }

    static FunctionInvocation stDevP(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    static FunctionInvocation stDevPDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.ST_DEV_P, expression);
    }

    static FunctionInvocation sum(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Aggregates.SUM, expression);
    }

    static FunctionInvocation sumDistinct(Expression expression) {
        return FunctionInvocation.createDistinct(BuiltInFunctions.Aggregates.SUM, expression);
    }

    static FunctionInvocation range(Integer start, Integer end) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end));
    }

    static FunctionInvocation range(Expression start, Expression end) {
        return Functions.range(start, end, null);
    }

    static FunctionInvocation range(Integer start, Integer end, Integer step) {
        return Functions.range(Cypher.literalOf(start), Cypher.literalOf(end), Cypher.literalOf(step));
    }

    static FunctionInvocation range(Expression start, Expression end, Expression step) {
        Assertions.notNull(start, "The expression for range is required.");
        Assertions.notNull(end, "The expression for range is required.");
        if (step == null) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RANGE, start, end, step);
    }

    static FunctionInvocation head(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.HEAD, expression);
    }

    static FunctionInvocation last(Expression expression) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.LAST, expression);
    }

    static FunctionInvocation nodes(NamedPath path) {
        Assertions.notNull(path, "The path for nodes is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.NODES, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException(Cypher.MESSAGES.getString("assertions.named-path-required"))));
    }

    static FunctionInvocation nodes(SymbolicName symbolicName) {
        Assertions.notNull(symbolicName, "The symbolic name of the path for nodes is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.NODES, symbolicName);
    }

    static FunctionInvocation relationships(NamedPath path) {
        Assertions.notNull(path, "The path for relationships is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RELATIONSHIPS, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException(Cypher.MESSAGES.getString("assertions.named-path-required"))));
    }

    static FunctionInvocation relationships(SymbolicName symbolicName) {
        Assertions.notNull(symbolicName, "The symbolic name of the path for relationships is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.RELATIONSHIPS, symbolicName);
    }

    static FunctionInvocation startNode(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.START_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    static FunctionInvocation endNode(Relationship relationship) {
        Assertions.notNull(relationship, "The relationship for endNode is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.END_NODE, relationship.getSymbolicName().orElseThrow(() -> new IllegalArgumentException("The relationship needs to be named!")));
    }

    static FunctionInvocation date() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATE);
    }

    static FunctionInvocation calendarDate(Integer year, Integer month, Integer day) {
        Assertions.notNull(year, Cypher.MESSAGES.getString("assertions.year-required"));
        Assertions.notNull(month, Cypher.MESSAGES.getString("assertions.month-required"));
        Assertions.notNull(day, Cypher.MESSAGES.getString("assertions.day-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf("year", Cypher.literalOf(year), "month", Cypher.literalOf(month), "day", Cypher.literalOf(day)));
    }

    static FunctionInvocation weekDate(Integer year, Integer week, Integer dayOfWeek) {
        Assertions.notNull(year, Cypher.MESSAGES.getString("assertions.year-required"));
        Object[] parameters = new Object[2 + (week != null ? 2 : 0) + (dayOfWeek != null ? 2 : 0)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (week != null) {
            parameters[i++] = "week";
            parameters[i++] = Cypher.literalOf(week);
        }
        if (dayOfWeek != null) {
            if (week == null) {
                throw new IllegalArgumentException("week is required when using dayOfWeek.");
            }
            parameters[i++] = "dayOfWeek";
            parameters[i] = Cypher.literalOf(dayOfWeek);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    static FunctionInvocation quarterDate(Integer year, Integer quarter, Integer dayOfQuarter) {
        Assertions.notNull(year, Cypher.MESSAGES.getString("assertions.year-required"));
        Object[] parameters = new Object[2 + (quarter != null ? 2 : 0) + (dayOfQuarter != null ? 2 : 0)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (quarter != null) {
            parameters[i++] = "quarter";
            parameters[i++] = Cypher.literalOf(quarter);
        }
        if (dayOfQuarter != null) {
            parameters[i++] = "dayOfQuarter";
            parameters[i] = Cypher.literalOf(dayOfQuarter);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    static FunctionInvocation ordinalDate(Integer year, Integer ordinalDay) {
        Assertions.notNull(year, Cypher.MESSAGES.getString("assertions.year-required"));
        Object[] parameters = new Object[2 + (ordinalDay != null ? 2 : 0)];
        int i = 0;
        parameters[i++] = "year";
        parameters[i++] = Cypher.literalOf(year);
        if (ordinalDay != null) {
            parameters[i++] = "ordinalDay";
            parameters[i] = Cypher.literalOf(ordinalDay);
        }
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.mapOf(parameters));
    }

    static FunctionInvocation date(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, components);
    }

    static FunctionInvocation date(String temporalValue) {
        Assertions.hasText(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, Cypher.literalOf(temporalValue));
    }

    static FunctionInvocation date(Expression temporalValue) {
        Assertions.notNull(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATE, temporalValue);
    }

    static FunctionInvocation datetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.DATETIME);
    }

    static FunctionInvocation datetime(TimeZone timeZone) {
        Assertions.notNull(timeZone, Cypher.MESSAGES.getString("assertions.tz-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    static FunctionInvocation datetime(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, components);
    }

    static FunctionInvocation datetime(String temporalValue) {
        Assertions.hasText(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, Cypher.literalOf(temporalValue));
    }

    static FunctionInvocation datetime(Expression temporalValue) {
        Assertions.notNull(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DATETIME, temporalValue);
    }

    static FunctionInvocation localdatetime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALDATETIME);
    }

    static FunctionInvocation localdatetime(TimeZone timeZone) {
        Assertions.notNull(timeZone, Cypher.MESSAGES.getString("assertions.tz-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    static FunctionInvocation localdatetime(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, components);
    }

    static FunctionInvocation localdatetime(String temporalValue) {
        Assertions.hasText(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, Cypher.literalOf(temporalValue));
    }

    static FunctionInvocation localdatetime(Expression temporalValue) {
        Assertions.notNull(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALDATETIME, temporalValue);
    }

    static FunctionInvocation localtime() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.LOCALTIME);
    }

    static FunctionInvocation localtime(TimeZone timeZone) {
        Assertions.notNull(timeZone, Cypher.MESSAGES.getString("assertions.tz-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    static FunctionInvocation localtime(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, components);
    }

    static FunctionInvocation localtime(String temporalValue) {
        Assertions.hasText(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, Cypher.literalOf(temporalValue));
    }

    static FunctionInvocation localtime(Expression temporalValue) {
        Assertions.notNull(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.LOCALTIME, temporalValue);
    }

    static FunctionInvocation time() {
        return FunctionInvocation.create(BuiltInFunctions.Temporals.TIME);
    }

    static FunctionInvocation time(TimeZone timeZone) {
        Assertions.notNull(timeZone, Cypher.MESSAGES.getString("assertions.tz-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Functions.timezoneMapLiteralOf(timeZone));
    }

    private static Expression timezoneMapLiteralOf(TimeZone timeZone) {
        return Cypher.mapOf("timezone", Cypher.literalOf(timeZone.getID()));
    }

    static FunctionInvocation time(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, components);
    }

    static FunctionInvocation time(String temporalValue) {
        Assertions.hasText(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, Cypher.literalOf(temporalValue));
    }

    static FunctionInvocation time(Expression temporalValue) {
        Assertions.notNull(temporalValue, Cypher.MESSAGES.getString("assertions.temporal-value-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.TIME, temporalValue);
    }

    static FunctionInvocation duration(MapExpression components) {
        Assertions.notNull(components, Cypher.MESSAGES.getString("assertions.components-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, components);
    }

    static FunctionInvocation duration(String temporalAmount) {
        Assertions.hasText(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, Cypher.literalOf(temporalAmount));
    }

    static FunctionInvocation duration(Expression temporalAmount) {
        Assertions.notNull(temporalAmount, "The temporalAmount is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Temporals.DURATION, temporalAmount);
    }

    static Reduction.OngoingDefinitionWithVariable reduce(SymbolicName variable) {
        return Reduction.of(variable);
    }

    static FunctionInvocation abs(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ABS, expression);
    }

    static FunctionInvocation ceil(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.CEIL, expression);
    }

    static FunctionInvocation floor(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.FLOOR, expression);
    }

    static FunctionInvocation rand() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.RAND);
    }

    static FunctionInvocation round(Expression value, Expression ... expression) {
        if (expression == null || expression.length == 0) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value);
        }
        if (expression.length == 1) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value, expression[0]);
        }
        if (expression.length == 2) {
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ROUND, value, expression[0], expression[1]);
        }
        throw new IllegalArgumentException("round() must be called with 1, 2 or 3 arguments (value, value + precision or value + precision + rounding mode.");
    }

    static FunctionInvocation sign(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SIGN, expression);
    }

    static FunctionInvocation e() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.E);
    }

    static FunctionInvocation exp(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.EXP, expression);
    }

    static FunctionInvocation log(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.LOG, expression);
    }

    static FunctionInvocation log10(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.LOG10, expression);
    }

    static FunctionInvocation sqrt(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SQRT, expression);
    }

    static FunctionInvocation acos(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ACOS, expression);
    }

    static FunctionInvocation asin(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ASIN, expression);
    }

    static FunctionInvocation atan(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ATAN, expression);
    }

    static FunctionInvocation atan2(Expression y, Expression x) {
        Assertions.notNull(y, "y is required.");
        Assertions.notNull(x, "x is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.ATAN2, y, x);
    }

    static FunctionInvocation cos(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.COS, expression);
    }

    static FunctionInvocation cot(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.COT, expression);
    }

    static FunctionInvocation degrees(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.DEGREES, expression);
    }

    static FunctionInvocation haversin(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.HAVERSIN, expression);
    }

    static FunctionInvocation pi() {
        return FunctionInvocation.create(BuiltInFunctions.MathematicalFunctions.PI);
    }

    static FunctionInvocation radians(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.RADIANS, expression);
    }

    static FunctionInvocation sin(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.SIN, expression);
    }

    static FunctionInvocation tan(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.MathematicalFunctions.TAN, expression);
    }

    static FunctionInvocation toInteger(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_INTEGER, expression);
    }

    static FunctionInvocation toString(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_STRING, expression);
    }

    static FunctionInvocation toStringOrNull(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Strings.TO_STRING_OR_NULL, Functions.expressionOrNullLit(expression));
    }

    static FunctionInvocation toFloat(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_FLOAT, expression);
    }

    static FunctionInvocation toBoolean(Expression expression) {
        Assertions.notNull(expression, Cypher.MESSAGES.getString("assertions.expression-required"));
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.TO_BOOLEAN, expression);
    }

    static FunctionInvocation linenumber() {
        return FunctionInvocation.create(() -> "linenumber");
    }

    static FunctionInvocation file() {
        return FunctionInvocation.create(() -> "file");
    }

    static FunctionInvocation randomUUID() {
        return FunctionInvocation.create(() -> "randomUUID");
    }

    static FunctionInvocation length(NamedPath path) {
        Assertions.notNull(path, "The path for length is required.");
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.LENGTH, path.getSymbolicName().orElseThrow(() -> new IllegalArgumentException(Cypher.MESSAGES.getString("assertions.named-path-required"))));
    }

    @Neo4jVersion(minimum="5.0.0")
    static FunctionInvocation graphNames() {
        return FunctionInvocation.create(BuiltInFunctions.Graph.NAMES);
    }

    @Neo4jVersion(minimum="5.0.0")
    static FunctionInvocation graphPropertiesByName(Expression name) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Graph.PROPERTIES_BY_NAME, name);
    }

    @Neo4jVersion(minimum="5.0.0")
    static FunctionInvocation graphByName(Expression name) {
        return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Graph.BY_NAME, name);
    }
}

