/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.TypedSubtree;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

public final class Labels
implements Visitable {
    private final Type type;
    private final boolean negated;
    private final List<Value> value;
    private final Labels lhs;
    private final Labels rhs;

    @Deprecated(forRemoval=true)
    static Labels of(LabelExpression labelExpression) {
        if (labelExpression == null) {
            return null;
        }
        Type type = Type.valueOf(labelExpression.type().name());
        List<String> value = labelExpression.value();
        List<Value> adaptedValue = value != null ? List.of(new Value(Modifier.STATIC, new TypedSubtree<NodeLabel>(value.stream().map(NodeLabel::new).toList()){

            @Override
            public String separator() {
                return "";
            }
        })) : List.of();
        return new Labels(type, labelExpression.negated(), adaptedValue, Labels.of(labelExpression.lhs()), Labels.of(labelExpression.rhs()));
    }

    static Labels exactly(String label) {
        return new Labels(Modifier.STATIC, new NodeLabel(label));
    }

    static Labels all(Expression expression) {
        return new Labels(Modifier.ALL, expression);
    }

    static Labels any(Expression expression) {
        return new Labels(Modifier.ANY, expression);
    }

    public static Labels colonConjunction(Collection<Value> values) {
        return new Labels(Type.COLON_CONJUNCTION, false, values != null ? List.copyOf(values) : List.of(), null, null);
    }

    Labels(Modifier modifier, Visitable labels) {
        this(Type.LEAF, false, List.of(new Value(modifier, labels)), null, null);
    }

    Labels(Type type, boolean negated, List<Value> value, Labels lhs, Labels rhs) {
        this.lhs = lhs;
        this.type = type;
        this.negated = negated;
        this.value = value;
        this.rhs = rhs;
    }

    public Labels and(Labels next) {
        return new Labels(Type.CONJUNCTION, false, null, this, next);
    }

    public Labels or(Labels next) {
        return new Labels(Type.DISJUNCTION, false, null, this, next);
    }

    public Labels negate() {
        return new Labels(this.type, !this.negated, this.value, this.lhs, this.rhs);
    }

    public Labels conjunctionWith(Labels other) {
        return this.colonJunction(other, Type.COLON_CONJUNCTION);
    }

    public Labels disjunctionWith(Labels other) {
        return this.colonJunction(other, Type.COLON_DISJUNCTION);
    }

    private Labels colonJunction(Labels other, Type colonDisjunction) {
        ArrayList<Value> hlp = new ArrayList<Value>(this.value.size() + other.getValue().size());
        hlp.addAll(this.value);
        hlp.addAll(other.value);
        return new Labels(colonDisjunction, false, List.copyOf(hlp), null, null);
    }

    public Labels getLhs() {
        return this.lhs;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Labels getRhs() {
        return this.rhs;
    }

    public Type getType() {
        return this.type;
    }

    public List<Value> getValue() {
        return this.value;
    }

    public Collection<String> getStaticValues() {
        LinkedHashSet<String> staticValues = new LinkedHashSet<String>();
        Labels.collectLabels(this, staticValues);
        return staticValues;
    }

    private static void collectLabels(Labels l, Set<String> labels) {
        if (l == null) {
            return;
        }
        Type current = l.getType();
        Labels.collectLabels(l.getLhs(), labels);
        if (current == Type.LEAF || l.getLhs() == null && l.getRhs() == null && EnumSet.of(Type.COLON_CONJUNCTION, Type.COLON_DISJUNCTION).contains((Object)l.getType())) {
            l.getValue().forEach(v -> v.accept(segment -> {
                if (segment instanceof NodeLabel) {
                    NodeLabel label = (NodeLabel)segment;
                    labels.add(label.getValue());
                }
            }));
        }
        Labels.collectLabels(l.getRhs(), labels);
    }

    boolean canBeUsedInUpdate() {
        boolean b;
        boolean bl = b = this.lhs == null && this.rhs == null && EnumSet.of(Type.LEAF, Type.COLON_CONJUNCTION).contains((Object)this.type);
        if (b) {
            b = !this.value.isEmpty() && this.value.get((int)0).modifier == Modifier.ALL;
        }
        return b;
    }

    public boolean isEmpty() {
        return !(this.value != null && !this.value.isEmpty() || this.lhs != null && !this.lhs.isEmpty() || this.rhs != null && !this.rhs.isEmpty());
    }

    public static enum Type {
        LEAF(""),
        COLON_CONJUNCTION(":"),
        COLON_DISJUNCTION(":"),
        CONJUNCTION("&"),
        DISJUNCTION("|");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public record Value(Modifier modifier, Visitable visitable) implements Visitable
    {
        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.visitable.accept(visitor);
            visitor.leave(this);
        }
    }

    public static enum Modifier {
        ALL,
        ANY,
        STATIC;

    }
}

