/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.STABLE, since="2024.7.0")
public interface PatternSelector
extends Visitable {
    public static PatternSelector shortestK(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("The path count needs to be greater than 0.");
        }
        return new ShortestK(k);
    }

    public static PatternSelector allShortest() {
        return new AllShortest();
    }

    public static PatternSelector shortestKGroups(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("The path count needs to be greater than 0.");
        }
        return new ShortestKGroups(k);
    }

    public static PatternSelector any() {
        return new Any();
    }

    public static final class ShortestK
    implements PatternSelector {
        private final int k;

        public ShortestK(Integer k) {
            this.k = k;
        }

        public int getK() {
            return this.k;
        }
    }

    public static final class AllShortest
    implements PatternSelector {
        private AllShortest() {
        }
    }

    public static final class ShortestKGroups
    implements PatternSelector {
        private final int k;

        ShortestKGroups(Integer k) {
            this.k = k;
        }

        public int getK() {
            return this.k;
        }
    }

    public static final class Any
    implements PatternSelector {
        private Any() {
        }
    }
}

