/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Configuration;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Dialect;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.GeneralizedRenderer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Renderer;

final class RendererBridge {
    private static final Configuration CONFIGURATION = Configuration.newConfig().withDialect(Dialect.NEO4J_5_DEFAULT_CYPHER).alwaysEscapeNames(false).build();

    private RendererBridge() {
    }

    static String render(Visitable visitable) {
        Class<?> clazz = visitable.getClass();
        String name = clazz.isAnonymousClass() ? clazz.getName() : clazz.getSimpleName();
        return "%s{cypher=%s}".formatted(name, Renderer.getRenderer(CONFIGURATION, GeneralizedRenderer.class).render(visitable));
    }
}

