/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DefaultStatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Limit;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Order;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RawLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ReturnBody;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Skip;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.Distinct;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Return
implements Clause {
    private final Distinct distinct;
    private final ReturnBody body;
    private final boolean raw;

    private Return(boolean raw, boolean distinct, ExpressionList returnItems, Order order, Skip skip, Limit limit) {
        this.distinct = !raw && distinct ? Distinct.INSTANCE : null;
        this.body = new ReturnBody(returnItems, order, skip, limit);
        this.raw = raw;
    }

    static Return create(boolean raw, boolean distinct, List<Expression> returnList, DefaultStatementBuilder.OrderBuilder orderBuilder) {
        if (returnList.isEmpty()) {
            return null;
        }
        if (raw) {
            AliasedExpression ae;
            String message = "A raw return must consist of exactly one raw expression.";
            Assertions.isTrue(returnList.size() == 1, message);
            Expression firstExpression = returnList.get(0);
            Assertions.isTrue(firstExpression instanceof RawLiteral || firstExpression instanceof AliasedExpression && (ae = (AliasedExpression)firstExpression).getDelegate() instanceof RawLiteral, message);
        }
        ExpressionList returnItems = new ExpressionList(returnList);
        return new Return(raw, distinct, returnItems, orderBuilder.buildOrder().orElse(null), orderBuilder.getSkip(), orderBuilder.getLimit());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.distinct, visitor);
        this.body.accept(visitor);
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL)
    public boolean isRaw() {
        return this.raw;
    }

    Distinct getDistinct() {
        return this.distinct;
    }

    ReturnBody getBody() {
        return this.body;
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

