/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ClausesBasedStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ImportingWith;
import org.neo4j.jdbc.internal.shaded.cypherdsl.InTransactions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RawLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class Subquery
extends AbstractClause
implements Clause {
    private final ImportingWith importingWith;
    private final Statement statement;
    private final RawLiteral rawStatement;

    private Subquery(ImportingWith importingWith, Statement statement) {
        this.importingWith = importingWith;
        this.statement = statement;
        this.rawStatement = null;
    }

    private Subquery(RawLiteral rawStatement) {
        this.rawStatement = rawStatement;
        this.importingWith = null;
        this.statement = null;
    }

    static Subquery raw(String format, Object ... mixedArgs) {
        return new Subquery(RawLiteral.create(format, mixedArgs));
    }

    static Subquery call(Statement statement, IdentifiableElement ... imports) {
        return new Subquery(ImportingWith.of(imports), statement);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.rawStatement != null) {
            this.rawStatement.accept(visitor);
        } else {
            this.importingWith.accept(visitor);
            this.statement.accept(visitor);
        }
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL)
    InTransactions inTransactionsOf(Integer rows) {
        return new InTransactions(this, rows);
    }

    @API(status=API.Status.INTERNAL)
    public boolean doesReturnOrYield() {
        return this.statement != null && this.statement.doesReturnOrYield();
    }

    @API(status=API.Status.INTERNAL)
    public With importingWith() {
        Statement statement;
        With imports;
        With with = imports = this.importingWith != null ? this.importingWith.imports() : null;
        if (imports == null && (statement = this.statement) instanceof ClausesBasedStatement) {
            ClausesBasedStatement cbs = (ClausesBasedStatement)statement;
            return cbs.getClauses().stream().findFirst().filter(With.class::isInstance).map(With.class::cast).orElse(null);
        }
        return imports;
    }
}

