/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.dotenv.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.stream.Stream;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvException;

public class ClasspathHelper {
    static Stream<String> loadFileFromClasspath(String location) {
        Class<ClasspathHelper> loader = ClasspathHelper.class;
        InputStream inputStream = loader.getResourceAsStream(location);
        if (inputStream == null) {
            inputStream = loader.getResourceAsStream(location);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(location);
        }
        if (inputStream == null) {
            throw new DotenvException("Could not find " + location + " on the classpath");
        }
        Scanner scanner = new Scanner(inputStream, "utf-8");
        ArrayList<String> lines = new ArrayList<String>();
        while (scanner.hasNext()) {
            lines.add(scanner.nextLine());
        }
        scanner.close();
        return lines.stream();
    }
}

