/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractAggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class AnyValue<T>
extends AbstractAggregateFunction<T>
implements QOM.AnyValue<T> {
    AnyValue(Field<T> field) {
        super(false, Names.N_ANY_VALUE, Tools.nullSafeDataType(field), Tools.nullSafeNotNull(field, SQLDataType.OTHER));
    }

    @Override
    void acceptFunctionName(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case POSTGRES: 
            case SQLITE: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_MIN);
                break;
            }
            case TRINO: {
                ctx.visit(Names.N_ARBITRARY);
                break;
            }
            default: {
                super.acceptFunctionName(ctx);
            }
        }
    }

    @Override
    public final Field<T> $field() {
        return (Field)this.getArguments().get(0);
    }

    @Override
    public final QOM.AnyValue<T> $field(Field<T> newValue) {
        return this.$constructor().apply(newValue);
    }

    public final Function1<? super Field<T>, ? extends QOM.AnyValue<T>> $constructor() {
        return a1 -> new AnyValue(a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.AnyValue) {
            QOM.AnyValue o = (QOM.AnyValue)that;
            return Objects.equals(this.$field(), o.$field());
        }
        return super.equals(that);
    }
}

