/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Expression;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Operators;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class BitAnd<T extends Number>
extends AbstractField<T>
implements QOM.BitAnd<T> {
    final Field<T> arg1;
    final Field<T> arg2;

    BitAnd(Field<T> arg1, Field<T> arg2) {
        super(Names.N_BIT_AND, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, arg1, false), arg1, arg2));
        this.arg1 = Tools.nullSafeNotNull(arg1, SQLDataType.INTEGER);
        this.arg2 = Tools.nullSafeNotNull(arg2, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: {
                return true;
            }
            case FIREBIRD: {
                return true;
            }
            case TRINO: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: {
                ctx.visit(DSL.function(Names.N_BITAND, this.getDataType(), this.arg1, this.arg2));
                break;
            }
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_BIN_AND, this.getDataType(), this.arg1, this.arg2));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_BITWISE_AND, this.getDataType(), this.arg1, this.arg2));
                break;
            }
            default: {
                ctx.sql('(');
                Expression.acceptAssociative(ctx, this, Operators.OP_AMP, c -> c.sql(' '));
                ctx.sql(')');
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.arg1;
    }

    @Override
    public final Field<T> $arg2() {
        return this.arg2;
    }

    @Override
    public final QOM.BitAnd<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.BitAnd<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.BitAnd<T>> $constructor() {
        return (a1, a2) -> new BitAnd(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.BitAnd) {
            QOM.BitAnd o = (QOM.BitAnd)that;
            return Objects.equals(this.$arg1(), o.$arg1()) && Objects.equals(this.$arg2(), o.$arg2());
        }
        return super.equals(that);
    }
}

