/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Ceil<T extends Number>
extends AbstractField<T>
implements QOM.Ceil<T> {
    final Field<T> value;

    Ceil(Field<T> value) {
        super(Names.N_CEIL, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                return false;
            }
            case H2: {
                return true;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_CEIL, this.getDataType(), this.value));
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_CEILING, this.getDataType(), this.value));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_CEIL, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.Ceil<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Field<T>, ? extends QOM.Ceil<T>> $constructor() {
        return a1 -> new Ceil(a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Ceil) {
            QOM.Ceil o = (QOM.Ceil)that;
            return Objects.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

