/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Condition;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Index;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.OrderField;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.SortField;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractNamed;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CommentImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QualifiedImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

class IndexImpl
extends AbstractNamed
implements Index,
QOM.UNotYetImplemented {
    private static final Set<SQLDialect> NO_SUPPORT_INDEX_QUALIFICATION = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    private final Table<?> table;
    private final SortField<?>[] fields;
    private final Condition where;
    private final boolean unique;

    IndexImpl(Name name) {
        this(name, null, Tools.EMPTY_SORTFIELD, null, false);
    }

    IndexImpl(Name name, Table<?> table, OrderField<?>[] fields, Condition where, boolean unique) {
        super(name.empty() ? name : IndexImpl.qualify(table, name), CommentImpl.NO_COMMENT);
        this.table = table;
        this.fields = Tools.sortFields(fields);
        this.where = where;
        this.unique = unique;
    }

    final SortField<?>[] $fields() {
        return this.fields;
    }

    final boolean $unique() {
        return this.unique;
    }

    final Condition $where() {
        return this.where;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_INDEX_QUALIFICATION.contains((Object)ctx.dialect())) {
            ctx.visit(this.getUnqualifiedName());
        } else if (this.getTable() == null) {
            ctx.visit(new QualifiedImpl(this.getQualifiedName()));
        } else {
            ctx.visit(new QualifiedImpl(DSL.name(this.getTable().getQualifiedName().qualifier(), this.getUnqualifiedName())));
        }
    }

    @Override
    public final Table<?> getTable() {
        return this.table;
    }

    @Override
    public final List<SortField<?>> getFields() {
        return Arrays.asList(this.fields);
    }

    @Override
    public final Condition getWhere() {
        return this.where;
    }

    @Override
    public boolean getUnique() {
        return this.unique;
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }
}

