/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigDecimal;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Log
extends AbstractField<BigDecimal>
implements QOM.Log {
    final Field<? extends Number> value;
    final Field<? extends Number> base;

    Log(Field<? extends Number> value, Field<? extends Number> base) {
        super(Names.N_LOG, Tools.allNotNull(SQLDataType.NUMERIC, value, base));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.base = Tools.nullSafeNotNull(base, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case DUCKDB: 
            case HSQLDB: 
            case IGNITE: 
            case SQLITE: {
                ctx.visit(Internal.idiv(DSL.ln(this.value), DSL.ln(this.base)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_LOG, SQLDataType.NUMERIC, this.base, this.value));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.value;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.base;
    }

    @Override
    public final QOM.Log $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue, (Field<? extends Number>)this.$arg2());
    }

    @Override
    public final QOM.Log $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)this.$arg1(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function2<? super Field<? extends Number>, ? super Field<? extends Number>, ? extends QOM.Log> $constructor() {
        return (a1, a2) -> new Log((Field<? extends Number>)a1, (Field<? extends Number>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Log) {
            QOM.Log o = (QOM.Log)that;
            return Objects.equals(this.$value(), o.$value()) && Objects.equals(this.$base(), o.$base());
        }
        return super.equals(that);
    }
}

