/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Function5;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Privilege;
import org.neo4j.jdbc.internal.shaded.jooq.RevokeFinalStep;
import org.neo4j.jdbc.internal.shaded.jooq.RevokeFromStep;
import org.neo4j.jdbc.internal.shaded.jooq.RevokeOnStep;
import org.neo4j.jdbc.internal.shaded.jooq.Role;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.User;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractDDLQuery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartListView;

final class RevokeImpl
extends AbstractDDLQuery
implements QOM.Revoke,
RevokeOnStep,
RevokeFromStep,
RevokeFinalStep {
    final QueryPartListView<? extends Privilege> privileges;
    final boolean grantOptionFor;
    Table<?> on;
    Role from;
    boolean fromPublic;
    private static final Clause[] CLAUSE = new Clause[]{Clause.REVOKE};

    RevokeImpl(Configuration configuration, Collection<? extends Privilege> privileges, boolean grantOptionFor) {
        this(configuration, privileges, grantOptionFor, null, null, false);
    }

    RevokeImpl(Configuration configuration, Collection<? extends Privilege> privileges, boolean grantOptionFor, Table<?> on, Role from, boolean fromPublic) {
        super(configuration);
        this.privileges = new QueryPartList<Privilege>((Iterable<? extends Privilege>)privileges);
        this.grantOptionFor = grantOptionFor;
        this.on = on;
        this.from = from;
        this.fromPublic = fromPublic;
    }

    @Override
    public final RevokeImpl on(String on) {
        return this.on((Table)DSL.table(DSL.name(on)));
    }

    @Override
    public final RevokeImpl on(Name on) {
        return this.on((Table)DSL.table(on));
    }

    @Override
    public final RevokeImpl on(Table<?> on) {
        this.on = on;
        return this;
    }

    @Override
    public final RevokeImpl from(User from) {
        return this.from(DSL.role(from.getQualifiedName()));
    }

    @Override
    public final RevokeImpl from(Role from) {
        this.from = from;
        return this;
    }

    @Override
    public final RevokeImpl fromPublic() {
        this.fromPublic = true;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.start(Clause.REVOKE_PRIVILEGE).visit(Keywords.K_REVOKE).sql(' ');
        if (this.grantOptionFor) {
            ctx.visit(Keywords.K_GRANT_OPTION_FOR).sql(' ');
        }
        ctx.visit(this.privileges).end(Clause.REVOKE_PRIVILEGE).sql(' ').start(Clause.REVOKE_ON).visit(Keywords.K_ON).sql(' ').visit(this.on).end(Clause.REVOKE_ON).sql(' ').start(Clause.REVOKE_FROM).visit(Keywords.K_FROM).sql(' ');
        if (this.from != null) {
            ctx.visit(this.from);
        } else if (this.fromPublic) {
            ctx.visit(Keywords.K_PUBLIC);
        }
        if (ctx.family() == SQLDialect.HSQLDB) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.REVOKE_FROM);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSE;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Privilege> $privileges() {
        return QOM.unmodifiable(this.privileges);
    }

    @Override
    public final boolean $grantOptionFor() {
        return this.grantOptionFor;
    }

    @Override
    public final Table<?> $on() {
        return this.on;
    }

    @Override
    public final Role $from() {
        return this.from;
    }

    @Override
    public final boolean $fromPublic() {
        return this.fromPublic;
    }

    @Override
    public final QOM.Revoke $privileges(Collection<? extends Privilege> newValue) {
        return this.$constructor().apply(newValue, this.$grantOptionFor(), this.$on(), this.$from(), this.$fromPublic());
    }

    @Override
    public final QOM.Revoke $grantOptionFor(boolean newValue) {
        return this.$constructor().apply(this.$privileges(), newValue, this.$on(), this.$from(), this.$fromPublic());
    }

    @Override
    public final QOM.Revoke $on(Table<?> newValue) {
        return this.$constructor().apply(this.$privileges(), this.$grantOptionFor(), newValue, this.$from(), this.$fromPublic());
    }

    @Override
    public final QOM.Revoke $from(Role newValue) {
        return this.$constructor().apply(this.$privileges(), this.$grantOptionFor(), this.$on(), newValue, this.$fromPublic());
    }

    @Override
    public final QOM.Revoke $fromPublic(boolean newValue) {
        return this.$constructor().apply(this.$privileges(), this.$grantOptionFor(), this.$on(), this.$from(), newValue);
    }

    public final Function5<? super Collection<? extends Privilege>, ? super Boolean, ? super Table<?>, ? super Role, ? super Boolean, ? extends QOM.Revoke> $constructor() {
        return (a1, a2, a3, a4, a5) -> new RevokeImpl(this.configuration(), (Collection<? extends Privilege>)a1, (boolean)a2, (Table<?>)a3, (Role)a4, (boolean)a5);
    }
}

