/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Right
extends AbstractField<String>
implements QOM.Right {
    final Field<String> string;
    final Field<? extends Number> length;

    Right(Field<String> string, Field<? extends Number> length) {
        super(Names.N_RIGHT, Tools.allNotNull(SQLDataType.VARCHAR, string, length));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.length = Tools.nullSafeNotNull(length, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                return false;
            }
            case SQLITE: 
            case TRINO: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(DSL.substring(this.string, Internal.iadd(DSL.length(this.string), Internal.isub(DSL.one(), this.length))));
                break;
            }
            case SQLITE: 
            case TRINO: {
                ctx.visit(DSL.substring(this.string, Internal.ineg(this.length)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_RIGHT, this.getDataType(), this.string, this.length));
            }
        }
    }

    @Override
    public final Field<String> $arg1() {
        return this.string;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.length;
    }

    @Override
    public final QOM.Right $arg1(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)newValue, (Field<? extends Number>)this.$arg2());
    }

    @Override
    public final QOM.Right $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function2<? super Field<String>, ? super Field<? extends Number>, ? extends QOM.Right> $constructor() {
        return (a1, a2) -> new Right((Field<String>)a1, (Field<? extends Number>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Right) {
            QOM.Right o = (QOM.Right)that;
            return Objects.equals(this.$string(), o.$string()) && Objects.equals(this.$length(), o.$length());
        }
        return super.equals(that);
    }
}

