/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RowIsNull
extends AbstractCondition
implements QOM.RowIsNull {
    static final Set<SQLDialect> EMULATE_NULL_ROW = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE, SQLDialect.TRINO);
    private final Row row;

    RowIsNull(Row row) {
        this.row = row;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_NULL_ROW.contains((Object)ctx.dialect())) {
            ctx.visit(Tools.allNull(Arrays.asList(this.row.fields())));
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(this.row);
        switch (ctx.family()) {
            default: 
        }
        ctx.sql(' ').visit(Keywords.K_IS_NULL);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Row $arg1() {
        return this.row;
    }

    @Override
    public final Function1<? super Row, ? extends QOM.RowIsNull> $constructor() {
        return r -> new RowIsNull((Row)r);
    }
}

