/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.neo4j.jdbc.internal.shaded.jooq.ExecuteContext;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.conf.SettingsTools;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SettingsEnabledPreparedStatement;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.DefaultConnection;

final class SettingsEnabledConnection
extends DefaultConnection {
    private final Settings settings;
    private final ExecuteContext ctx;
    private final boolean forceStaticStatements;

    SettingsEnabledConnection(Connection delegate, Settings settings, ExecuteContext ctx) {
        this(delegate, settings, ctx, false);
    }

    SettingsEnabledConnection(Connection delegate, Settings settings, ExecuteContext ctx, boolean forceStaticStatements) {
        super(delegate);
        this.settings = settings;
        this.ctx = ctx;
        this.forceStaticStatements = forceStaticStatements;
    }

    private final boolean executePreparedStatements0() {
        return !this.forceStaticStatements && (this.ctx == null || !Boolean.TRUE.equals(this.ctx.data(Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT))) && SettingsTools.executePreparedStatements(this.settings);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql, autoGeneratedKeys);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, autoGeneratedKeys);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql, columnIndexes);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, columnIndexes);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.executePreparedStatements0()) {
            return this.getDelegate().prepareStatement(sql, columnNames);
        }
        return new SettingsEnabledPreparedStatement(this.getDelegate(), sql, columnNames);
    }
}

