/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.jdbc.internal.shaded.jooq.Catalog;
import org.neo4j.jdbc.internal.shaded.jooq.Check;
import org.neo4j.jdbc.internal.shaded.jooq.Domain;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.ForeignKey;
import org.neo4j.jdbc.internal.shaded.jooq.Index;
import org.neo4j.jdbc.internal.shaded.jooq.Meta;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.Sequence;
import org.neo4j.jdbc.internal.shaded.jooq.SortField;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.UDT;
import org.neo4j.jdbc.internal.shaded.jooq.UDTRecord;
import org.neo4j.jdbc.internal.shaded.jooq.UniqueKey;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataAccessException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractMeta;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CatalogImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DomainImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IndexImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SchemaImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SequenceImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.impl.UDTImpl;

final class Snapshot
extends AbstractMeta {
    private Meta delegate;

    Snapshot(Meta meta) {
        super(meta.configuration());
        this.delegate = meta;
        this.getCatalogs();
        this.delegate = null;
        this.resolveReferences();
    }

    @Override
    final AbstractMeta filtered0(Predicate<? super Catalog> catalogFilter, Predicate<? super Schema> schemaFilter) {
        return this;
    }

    private final void resolveReferences() {
        for (Catalog catalog : this.getCatalogs()) {
            ((SnapshotCatalog)catalog).resolveReferences();
        }
    }

    @Override
    final List<Catalog> getCatalogs0() throws DataAccessException {
        return Tools.map(this.delegate.getCatalogs(), x$0 -> new SnapshotCatalog((Catalog)x$0));
    }

    private class SnapshotCatalog
    extends CatalogImpl {
        private final List<SnapshotSchema> schemas;

        SnapshotCatalog(Catalog catalog) {
            super(catalog.getQualifiedName(), catalog.getCommentPart());
            this.schemas = Tools.map(catalog.getSchemas(), s -> new SnapshotSchema(this, (Schema)s));
        }

        private final void resolveReferences() {
            for (SnapshotSchema schema : this.schemas) {
                schema.resolveReferences();
            }
        }

        @Override
        public final List<Schema> getSchemas() {
            return Collections.unmodifiableList(this.schemas);
        }
    }

    private class SnapshotUDT<R extends UDTRecord<R>>
    extends UDTImpl<R> {
        SnapshotUDT(SnapshotSchema schema, UDT<R> udt) {
            super(udt.getUnqualifiedName(), (Schema)schema, udt.getPackage(), udt.isSynthetic());
        }
    }

    private class SnapshotSequence<T extends Number>
    extends SequenceImpl<T> {
        SnapshotSequence(SnapshotSchema schema, Sequence<T> sequence) {
            super(sequence.getQualifiedName(), schema, sequence.getDataType(), false, sequence.getStartWith(), sequence.getIncrementBy(), sequence.getMinvalue(), sequence.getMaxvalue(), sequence.getCycle(), sequence.getCache());
        }
    }

    private class SnapshotTable<R extends Record>
    extends TableImpl<R> {
        private final List<Index> indexes;
        private final List<UniqueKey<R>> uniqueKeys;
        private UniqueKey<R> primaryKey;
        private final List<ForeignKey<R, ?>> foreignKeys;
        private final List<Check<R>> checks;

        SnapshotTable(SnapshotSchema schema, Table<R> table) {
            super(table.getQualifiedName(), schema, null, null, table.getCommentPart(), table.getOptions());
            for (Field<?> field : table.fields()) {
                SnapshotTable.createField(field.getUnqualifiedName(), field.getDataType(), this, field.getComment());
            }
            this.indexes = Tools.map(table.getIndexes(), index -> new IndexImpl(index.getQualifiedName(), this, Tools.map(index.getFields(), field -> {
                Field<?> f = this.field(field.getName());
                return f != null ? f.sort(field.getOrder()) : field;
            }, SortField[]::new), index.getWhere(), index.getUnique()));
            this.uniqueKeys = Tools.map(table.getUniqueKeys(), uk -> Internal.createUniqueKey(this, uk.getQualifiedName(), this.fields(uk.getFieldsArray()), uk.enforced()));
            UniqueKey<R> pk = table.getPrimaryKey();
            if (pk != null) {
                this.primaryKey = Internal.createUniqueKey(this, pk.getQualifiedName(), this.fields(pk.getFieldsArray()), pk.enforced());
            }
            this.foreignKeys = new ArrayList(table.getReferences());
            this.checks = new ArrayList<Check<R>>(table.getChecks());
        }

        @Deprecated
        private final TableField<R, ?>[] fields(TableField<R, ?>[] tableFields) {
            return Tools.map(tableFields, f -> (TableField)this.field(f.getName()), TableField[]::new);
        }

        final void resolveReferences() {
            for (int i = 0; i < this.foreignKeys.size(); ++i) {
                ForeignKey<R, ?> fk = this.foreignKeys.get(i);
                UniqueKey<?> uk = Snapshot.this.lookupUniqueKey(fk);
                if (uk == null) {
                    this.foreignKeys.remove(i);
                    continue;
                }
                this.foreignKeys.set(i, AbstractMeta.copyFK(this, uk, fk));
            }
        }

        @Override
        public final List<Index> getIndexes() {
            return Collections.unmodifiableList(this.indexes);
        }

        @Override
        public final List<UniqueKey<R>> getUniqueKeys() {
            return Collections.unmodifiableList(this.uniqueKeys);
        }

        @Override
        public final UniqueKey<R> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public final List<ForeignKey<R, ?>> getReferences() {
            return Collections.unmodifiableList(this.foreignKeys);
        }

        @Override
        public final List<Check<R>> getChecks() {
            return Collections.unmodifiableList(this.checks);
        }
    }

    private class SnapshotDomain<T>
    extends DomainImpl<T> {
        SnapshotDomain(SnapshotSchema schema, Domain<T> domain) {
            super(schema, domain.getQualifiedName(), domain.getDataType(), domain.getChecks().toArray(Tools.EMPTY_CHECK));
        }
    }

    private class SnapshotSchema
    extends SchemaImpl {
        private final List<SnapshotDomain<?>> domains;
        private final List<SnapshotTable<?>> tables;
        private final List<SnapshotSequence<?>> sequences;
        private final List<SnapshotUDT<?>> udts;

        SnapshotSchema(SnapshotCatalog catalog, Schema schema) {
            super(schema.getQualifiedName(), (Catalog)catalog, schema.getCommentPart());
            this.domains = Tools.map(schema.getDomains(), d -> new SnapshotDomain(this, d));
            this.tables = Tools.map(schema.getTables(), t -> new SnapshotTable(this, t));
            this.sequences = Tools.map(schema.getSequences(), s -> new SnapshotSequence(this, s));
            this.udts = Tools.map(schema.getUDTs(), u -> new SnapshotUDT(this, u));
        }

        final void resolveReferences() {
            for (SnapshotTable<?> table : this.tables) {
                table.resolveReferences();
            }
        }

        @Override
        public final List<Domain<?>> getDomains() {
            return Collections.unmodifiableList(this.domains);
        }

        @Override
        public final List<Table<?>> getTables() {
            return Collections.unmodifiableList(this.tables);
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return Collections.unmodifiableList(this.sequences);
        }

        @Override
        public final List<UDT<?>> getUDTs() {
            return Collections.unmodifiableList(this.udts);
        }
    }
}

