/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRowAsField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RecordDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RowAsField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ScopeMappableWrapper;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SelectFieldList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class TableAsField<R extends Record>
extends AbstractRowAsField<R>
implements QOM.TableAsField<R>,
ScopeMappableWrapper<TableAsField<R>, Table<R>> {
    final Table<R> table;

    TableAsField(Table<R> table) {
        this(table, table.getQualifiedName());
    }

    TableAsField(Table<R> table, Name as) {
        super(as, new RecordDataType(((AbstractTable)table).fieldsRow(), table.getRecordType(), table.getName()));
        this.table = table;
    }

    @Override
    final Table<R> fields0() {
        return this.table;
    }

    @Override
    final Class<R> getRecordType() {
        return this.table.getRecordType();
    }

    @Override
    final void acceptDefault(Context<?> ctx) {
        if (RowAsField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            ctx.data(Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c -> c.visit(new SelectFieldList((SelectFieldOrAsterisk[])this.emulatedFields((Configuration)ctx.configuration()).fields.fields)));
        } else {
            ctx.visit(new RowAsField(this.table.fieldsRow(), this.getQualifiedName()));
        }
    }

    @Override
    public Field<R> as(Name alias) {
        return new TableAsField<R>(this.table, alias);
    }

    @Override
    public final Field<?> $aliased() {
        return new TableAsField<R>(this.table);
    }

    @Override
    public final Name $alias() {
        return this.getQualifiedName();
    }

    @Override
    public final Table<R> $table() {
        return this.table;
    }

    @Override
    public final TableAsField<R> wrap(Table<R> wrapped) {
        return new TableAsField<R>(wrapped, this.getQualifiedName());
    }
}

