/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.GroupField;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.SelectHavingConditionStep;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Unique
extends AbstractCondition
implements QOM.Unique {
    final Select<?> query;

    Unique(Select<?> query) {
        this.query = query;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(Keywords.K_UNIQUE).sql(' ');
                Tools.visitSubquery(ctx, this.query, 256);
                break;
            }
            default: {
                Table queryTable = this.query.asTable("t");
                GroupField[] queryFields = queryTable.fields();
                SelectHavingConditionStep subquery = DSL.select(DSL.one()).from((TableLike<?>)queryTable).where(DSL.row(queryFields).isNotNull()).groupBy(queryFields).having(DSL.count().gt(DSL.one()));
                ctx.visit(DSL.notExists(subquery));
            }
        }
    }

    @Override
    public final Select<?> $arg1() {
        return this.query;
    }

    @Override
    public final QOM.Unique $arg1(Select<?> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Select<?>, ? extends QOM.Unique> $constructor() {
        return a1 -> new Unique((Select<?>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Unique) {
            QOM.Unique o = (QOM.Unique)that;
            return Objects.equals(this.$query(), o.$query());
        }
        return super.equals(that);
    }
}

