/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.sparkcleaner;

import java.sql.DatabaseMetaData;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.BailErrorStrategy;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.CharStreams;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.CommonTokenStream;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.atn.ParserATNSimulator;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.atn.PredictionMode;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.antlr.v4.runtime.misc.ParseCancellationException;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.parser.common.v5.Cypher5Lexer;
import org.neo4j.jdbc.translator.sparkcleaner.internal.shaded.parser.common.v5.Cypher5Parser;
import org.neo4j.jdbc.translator.spi.Translator;

final class SparkSubqueryCleaningTranslator
implements Translator {
    private static final Pattern SUBQUERY_PATTERN = Pattern.compile("(?ims)SELECT\\s+\\*\\s+FROM\\s+\\((.*?)\\)\\s+SPARK_GEN_SUBQ_0.*");
    private final int precedence;

    SparkSubqueryCleaningTranslator(int precedence) {
        this.precedence = precedence;
    }

    @Override
    public int getOrder() {
        return this.precedence;
    }

    @Override
    public String translate(String statement, DatabaseMetaData optionalDatabaseMetaData) {
        if (!SparkSubqueryCleaningTranslator.mightBeASparkQuery(statement)) {
            return null;
        }
        Optional<String> extractedSubquery = SparkSubqueryCleaningTranslator.extractSubquery(statement);
        return extractedSubquery.filter(this::canParseAsCypher).map(v -> "/*+ NEO4J FORCE_CYPHER */\nCALL {%s} RETURN * LIMIT 1\n".formatted(v).strip()).orElse(null);
    }

    static boolean mightBeASparkQuery(String statement) {
        return statement != null && statement.toUpperCase(Locale.ROOT).contains("SPARK_GEN_SUBQ");
    }

    static Optional<String> extractSubquery(String statement) {
        Matcher matcher = SUBQUERY_PATTERN.matcher(statement);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(1).trim());
    }

    boolean canParseAsCypher(String statement) {
        CommonTokenStream tokens = new CommonTokenStream(new Cypher5Lexer(CharStreams.fromString(statement)));
        Cypher5Parser parser = new Cypher5Parser(tokens);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.setErrorHandler(new BailErrorStrategy());
        try {
            parser.statements();
        }
        catch (Exception ex) {
            tokens.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            try {
                parser.statements();
            }
            catch (ParseCancellationException ex2) {
                return false;
            }
        }
        return true;
    }
}

