/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.neo4j.jdbc.values.Vector;

final class ArrayBasedVectors {
    static final String MSG_NULL_CHECK = "Vector elements must not be literal null";
    static final Function<Vector, Object> ELEMENT_ACCESSOR = vector -> {
        Objects.requireNonNull(vector);
        if (vector instanceof Int8VectorImpl) {
            Int8VectorImpl int8Vector = (Int8VectorImpl)vector;
            return int8Vector.elements();
        }
        if (vector instanceof Int16VectorImpl) {
            Int16VectorImpl v = (Int16VectorImpl)vector;
            return v.elements();
        }
        if (vector instanceof Int32VectorImpl) {
            Int32VectorImpl v = (Int32VectorImpl)vector;
            return v.elements();
        }
        if (vector instanceof Int64VectorImpl) {
            Int64VectorImpl v = (Int64VectorImpl)vector;
            return v.elements();
        }
        if (vector instanceof Float32VectorImpl) {
            Float32VectorImpl v = (Float32VectorImpl)vector;
            return v.elements();
        }
        if (vector instanceof Float64VectorImpl) {
            Float64VectorImpl v = (Float64VectorImpl)vector;
            return v.elements();
        }
        throw new IllegalArgumentException("Unsupported vector implementation: " + vector.getClass().getName());
    };

    private ArrayBasedVectors() {
    }

    static String toString(Vector vector) {
        String value = vector.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        return "vector(%s, %d, %s NOT NULL)".formatted(new Object[]{value, vector.size(), vector.elementType()});
    }

    record Int8VectorImpl(Vector.ElementType elementType, int size, byte[] elements) implements Vector.Int8Vector
    {
        @Override
        public byte[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Byte> stream() {
            return IntStream.range(0, this.elements.length).mapToObj(i -> this.elements[i]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Int8VectorImpl that = (Int8VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }

    record Int16VectorImpl(Vector.ElementType elementType, int size, short[] elements) implements Vector.Int16Vector
    {
        @Override
        public short[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Short> stream() {
            return IntStream.range(0, this.elements.length).mapToObj(i -> this.elements[i]);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Int16VectorImpl that = (Int16VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }

    record Int32VectorImpl(Vector.ElementType elementType, int size, int[] elements) implements Vector.Int32Vector
    {
        @Override
        public int[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Integer> stream() {
            return Arrays.stream(this.elements).boxed();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Int32VectorImpl that = (Int32VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }

    record Int64VectorImpl(Vector.ElementType elementType, int size, long[] elements) implements Vector.Int64Vector
    {
        @Override
        public long[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Long> stream() {
            return Arrays.stream(this.elements).boxed();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Int64VectorImpl that = (Int64VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }

    record Float32VectorImpl(Vector.ElementType elementType, int size, float[] elements) implements Vector.Float32Vector
    {
        @Override
        public float[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Float> stream() {
            return IntStream.range(0, this.elements.length).mapToObj(i -> Float.valueOf(this.elements[i]));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Float32VectorImpl that = (Float32VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }

    record Float64VectorImpl(Vector.ElementType elementType, int size, double[] elements) implements Vector.Float64Vector
    {
        @Override
        public double[] toArray() {
            return Arrays.copyOf(this.elements, this.size);
        }

        public Stream<Double> stream() {
            return Arrays.stream(this.elements).boxed();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Float64VectorImpl that = (Float64VectorImpl)obj;
            return Objects.equals((Object)this.elementType, (Object)that.elementType) && this.size == that.size && Arrays.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.elementType, this.size, Arrays.hashCode(this.elements)});
        }

        @Override
        public String toString() {
            return ArrayBasedVectors.toString(this);
        }
    }
}

