/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;

public class ChunkDecoder
extends LengthFieldBasedFrameDecoder {
    private static final int MAX_FRAME_BODY_LENGTH = 65535;
    private static final int LENGTH_FIELD_OFFSET = 0;
    private static final int LENGTH_FIELD_LENGTH = 2;
    private static final int LENGTH_ADJUSTMENT = 0;
    private static final int INITIAL_BYTES_TO_STRIP = 2;
    private static final int MAX_FRAME_LENGTH = 65537;
    private final LoggingProvider logging;
    private System.Logger log;

    public ChunkDecoder(LoggingProvider logging) {
        super(65537, 0, 2, 0, 2);
        this.logging = logging;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, ((Object)((Object)this)).getClass());
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.log = null;
    }

    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        if (this.log.isLoggable(System.Logger.Level.TRACE)) {
            int originalReaderIndex = buffer.readerIndex();
            int readerIndexWithChunkHeader = originalReaderIndex - 2;
            int lengthWithChunkHeader = 2 + length;
            String hexDump = ByteBufUtil.hexDump((ByteBuf)buffer, (int)readerIndexWithChunkHeader, (int)lengthWithChunkHeader);
            this.log.log(System.Logger.Level.TRACE, "S: %s", hexDump);
        }
        return super.extractFrame(ctx, buffer, index, length);
    }
}

