/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.messaging.v53;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.exception.BoltException;
import org.neo4j.bolt.connection.netty.impl.RoutingContext;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.bolt.connection.netty.impl.handlers.HelloV51ResponseHandler;
import org.neo4j.bolt.connection.netty.impl.handlers.LogonResponseHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.BoltProtocol;
import org.neo4j.bolt.connection.netty.impl.messaging.request.HelloMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.request.LogonMessage;
import org.neo4j.bolt.connection.netty.impl.messaging.v52.BoltProtocolV52;
import org.neo4j.bolt.connection.observation.BoltExchangeObservation;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public class BoltProtocolV53
extends BoltProtocolV52 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 3);
    public static final BoltProtocol INSTANCE = new BoltProtocolV53();

    @Override
    public CompletionStage<Channel> initializeChannel(Channel channel, String userAgent, BoltAgent boltAgent, Map<String, Value> authMap, RoutingContext routingContext, NotificationConfig notificationConfig, Clock clock, CompletableFuture<Long> latestAuthMillisFuture, ValueFactory valueFactory, BoltExchangeObservation observation) {
        BoltException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            return CompletableFuture.failedStage((Throwable)exception);
        }
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), routingContext.toMap(), false, notificationConfig, this.useLegacyNotifications(), valueFactory) : new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), null, false, notificationConfig, this.useLegacyNotifications(), valueFactory);
        CompletableFuture<String> helloFuture = new CompletableFuture<String>();
        ChannelAttributes.messageDispatcher(channel).enqueue(new HelloV51ResponseHandler(channel, helloFuture));
        channel.write((Object)message).addListener((GenericFutureListener)((ChannelFutureListener)writeFuture -> {
            if (writeFuture.isSuccess()) {
                observation.onWrite(message.name());
            }
        }));
        CompletableFuture logonFuture = new CompletableFuture();
        LogonMessage logon = new LogonMessage(authMap, valueFactory);
        ChannelAttributes.messageDispatcher(channel).enqueue(new LogonResponseHandler(logonFuture, channel, clock, latestAuthMillisFuture));
        channel.writeAndFlush((Object)logon).addListener((GenericFutureListener)((ChannelFutureListener)writeFuture -> {
            if (writeFuture.isSuccess()) {
                observation.onWrite(logon.name());
            }
        }));
        return ((CompletableFuture)helloFuture.thenCompose(ignored -> {
            observation.onSummary(message.name());
            return logonFuture;
        })).thenApply(ignored -> {
            observation.onSummary(logon.name());
            return channel;
        });
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

